/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.dataset;

import com.atlassian.performance.tools.infrastructure.HttpResource;
import com.atlassian.performance.tools.infrastructure.Ls;
import com.atlassian.performance.tools.infrastructure.api.dataset.DatasetPackage;
import com.atlassian.performance.tools.infrastructure.api.dataset.FileArchiver;
import com.atlassian.performance.tools.jvmtasks.api.TaskTimer;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Can be inlined into `com.atlassian.performance.tools.infrastructure.api.dataset.HttpDatasetPackage` after `ObsoleteHttpDatasetPackage` removed.")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\b\u0010\f\u001a\u00020\bH\u0016J \u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/performance/tools/infrastructure/dataset/HttpDatasetPackage;", "Lcom/atlassian/performance/tools/infrastructure/api/dataset/DatasetPackage;", "uri", "Ljava/net/URI;", "timeout", "Ljava/time/Duration;", "(Ljava/net/URI;Ljava/time/Duration;)V", "download", "", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "resourceName", "toString", "unzip", "timeForUnzipping", "infrastructure"})
public final class HttpDatasetPackage
implements DatasetPackage {
    private final URI uri;
    private final Duration timeout;

    @Override
    @NotNull
    public String download(@NotNull SshConnection ssh) {
        Duration timeForUnzipping;
        String resourceName;
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        String string = resourceName = FilenameUtils.getName((String)this.uri.getPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resourceName");
        Duration downloadDuration = this.download(ssh, string);
        Duration duration = timeForUnzipping = this.timeout.minus(downloadDuration);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"timeForUnzipping");
        if (duration.isNegative()) {
            throw (Throwable)new Exception("The archive has been download successfully, but no time to unzip left.");
        }
        return this.unzip(ssh, resourceName, timeForUnzipping);
    }

    private final Duration download(SshConnection ssh, String resourceName) {
        Instant start2 = Instant.now();
        TaskTimer.INSTANCE.time("download", (Function0)new Function0<Unit>(this, ssh, resourceName){
            final /* synthetic */ HttpDatasetPackage this$0;
            final /* synthetic */ SshConnection $ssh;
            final /* synthetic */ String $resourceName;

            public final void invoke() {
                new HttpResource(HttpDatasetPackage.access$getUri$p(this.this$0)).download(this.$ssh, this.$resourceName, HttpDatasetPackage.access$getTimeout$p(this.this$0));
            }
            {
                this.this$0 = httpDatasetPackage;
                this.$ssh = sshConnection;
                this.$resourceName = string;
                super(0);
            }
        });
        Instant afterDownload = Instant.now();
        Duration duration = Duration.between(start2, afterDownload);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.between(start, afterDownload)");
        return duration;
    }

    private final String unzip(SshConnection ssh, String resourceName, Duration timeForUnzipping) {
        String destination = UUID.randomUUID().toString();
        ssh.execute("mkdir " + destination);
        FileArchiver fileArchiver = new FileArchiver();
        String string = destination;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"destination");
        fileArchiver.unzip$infrastructure(ssh, resourceName, string, timeForUnzipping);
        Set<String> newFiles = new Ls().execute$infrastructure(ssh, destination);
        String string2 = (String)CollectionsKt.singleOrNull((Iterable)newFiles);
        if (string2 == null) {
            throw (Throwable)new Exception("Expected one new folder. Found " + newFiles + '.');
        }
        String dataset = string2;
        return StringsKt.trimEnd((String)ssh.execute("cd '" + destination + '/' + dataset + "' && pwd").getOutput(), (char[])new char[]{'\n'});
    }

    @NotNull
    public String toString() {
        return "HttpDatasetPackage(uri='" + this.uri + "', timeout=" + this.timeout + ')';
    }

    public HttpDatasetPackage(@NotNull URI uri, @NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        this.uri = uri;
        this.timeout = timeout;
    }

    @NotNull
    public static final /* synthetic */ URI access$getUri$p(HttpDatasetPackage $this) {
        return $this.uri;
    }

    @NotNull
    public static final /* synthetic */ Duration access$getTimeout$p(HttpDatasetPackage $this) {
        return $this.timeout;
    }
}

