/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.database;

import com.atlassian.performance.tools.infrastructure.api.docker.DockerContainer;
import com.atlassian.performance.tools.infrastructure.api.os.Ubuntu;
import com.atlassian.performance.tools.infrastructure.database.SshMysqlClient;
import com.atlassian.performance.tools.infrastructure.database.SshSqlClient;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ/\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/performance/tools/infrastructure/database/Mysql;", "", "()V", "jiraDocsBasedArgs", "", "", "[Ljava/lang/String;", "logger", "Lorg/apache/logging/log4j/Logger;", "ubuntu", "Lcom/atlassian/performance/tools/infrastructure/api/os/Ubuntu;", "awaitDatabase", "", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "container", "Lcom/atlassian/performance/tools/infrastructure/api/docker/DockerContainer;", "dataDir", "extraParameters", "extraArguments", "(Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)Lcom/atlassian/performance/tools/infrastructure/api/docker/DockerContainer;", "installClient", "Lcom/atlassian/performance/tools/infrastructure/database/SshSqlClient;", "infrastructure"})
public final class Mysql {
    private static final Logger logger;
    private static final Ubuntu ubuntu;
    private static final String[] jiraDocsBasedArgs;
    public static final Mysql INSTANCE;

    @NotNull
    public final SshSqlClient installClient(@NotNull SshConnection ssh) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Ubuntu.install$default(ubuntu, ssh, CollectionsKt.listOf((Object)"mysql-client"), null, 4, null);
        return new SshMysqlClient();
    }

    @NotNull
    public final DockerContainer container(@NotNull String dataDir, @NotNull String[] extraParameters, @NotNull String[] extraArguments) {
        Intrinsics.checkParameterIsNotNull((Object)dataDir, (String)"dataDir");
        Intrinsics.checkParameterIsNotNull((Object)extraParameters, (String)"extraParameters");
        Intrinsics.checkParameterIsNotNull((Object)extraArguments, (String)"extraArguments");
        DockerContainer.Builder builder = new DockerContainer.Builder().imageName("mysql:5.7.32");
        Duration duration = Duration.ofMinutes(5L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(5)");
        DockerContainer.Builder builder2 = builder.pullTimeout(duration);
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add((Object)"-p 3306:3306");
        spreadBuilder.add((Object)("-v `realpath " + dataDir + "`:/var/lib/mysql"));
        spreadBuilder.addSpread((Object)extraParameters);
        DockerContainer.Builder builder3 = builder2.parameters((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        SpreadBuilder spreadBuilder2 = new SpreadBuilder(2);
        spreadBuilder2.addSpread((Object)jiraDocsBasedArgs);
        spreadBuilder2.addSpread((Object)extraArguments);
        return builder3.arguments((String[])spreadBuilder2.toArray((Object[])new String[spreadBuilder2.size()])).build();
    }

    public final void awaitDatabase(@NotNull SshConnection ssh) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Instant mysqlStart = Instant.now();
        while (!ssh.safeExecute("mysql -h 127.0.0.1 -u root -e 'select 1;'").isSuccessful()) {
            if (Instant.now().compareTo(mysqlStart.plus(Duration.ofMinutes(15L))) > 0) {
                throw (Throwable)new RuntimeException("MySQL didn't start in time");
            }
            logger.debug("Waiting for MySQL...");
            Thread.sleep(Duration.ofSeconds(10L).toMillis());
        }
    }

    private Mysql() {
    }

    static {
        Mysql mysql;
        INSTANCE = mysql = new Mysql();
        Logger logger = LogManager.getLogger(mysql.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        Mysql.logger = logger;
        ubuntu = new Ubuntu();
        jiraDocsBasedArgs = new String[]{"--default-storage-engine=INNODB", "--character-set-server=utf8mb4", "--innodb-default-row-format=DYNAMIC", "--innodb-large-prefix=ON", "--innodb-file-format=Barracuda", "--innodb-log-file-size=2G"};
    }
}

