/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.virtualusers;

import com.atlassian.performance.tools.infrastructure.VirtualUsersJar;
import com.atlassian.performance.tools.infrastructure.api.jvm.JavaDevelopmentKit;
import com.atlassian.performance.tools.infrastructure.api.jvm.OpenJDK11;
import com.atlassian.performance.tools.infrastructure.api.os.OsMetric;
import com.atlassian.performance.tools.infrastructure.api.os.Ubuntu;
import com.atlassian.performance.tools.infrastructure.api.os.Vmstat;
import com.atlassian.performance.tools.infrastructure.api.process.RemoteMonitoringProcess;
import com.atlassian.performance.tools.infrastructure.api.virtualusers.ResultsTransport;
import com.atlassian.performance.tools.infrastructure.api.virtualusers.VirtualUsers;
import com.atlassian.performance.tools.infrastructure.os.Iostat;
import com.atlassian.performance.tools.infrastructure.os.Pidstat;
import com.atlassian.performance.tools.jvmtasks.api.TaskTimer;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserOptions;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0016H\u0002J\b\u0010\u001c\u001a\u00020\u0003H\u0016R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/SshVirtualUsers;", "Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/VirtualUsers;", "name", "", "nodeOrder", "", "resultsTransport", "Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/ResultsTransport;", "jarName", "ssh", "Lcom/atlassian/performance/tools/ssh/api/Ssh;", "(Ljava/lang/String;ILcom/atlassian/performance/tools/infrastructure/api/virtualusers/ResultsTransport;Ljava/lang/String;Lcom/atlassian/performance/tools/ssh/api/Ssh;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "monitoringProcesses", "", "Lcom/atlassian/performance/tools/infrastructure/api/process/RemoteMonitoringProcess;", "getSsh", "()Lcom/atlassian/performance/tools/ssh/api/Ssh;", "applyLoad", "", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "options", "Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserOptions;", "gatherResults", "startCollectingMetrics", "stopCollectingMetrics", "toString", "infrastructure"})
public final class SshVirtualUsers
implements VirtualUsers {
    private final Logger logger;
    private final List<RemoteMonitoringProcess> monitoringProcesses;
    private final String name;
    private final int nodeOrder;
    private final ResultsTransport resultsTransport;
    private final String jarName;
    @NotNull
    private final Ssh ssh;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyLoad(@NotNull VirtualUserOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.logger.debug("Applying load via " + this.name + "...");
        Closeable closeable = (Closeable)this.ssh.newConnection();
        Throwable throwable = null;
        try {
            SshConnection ssh = (SshConnection)closeable;
            this.startCollectingMetrics(ssh);
            this.applyLoad(ssh, options);
            this.stopCollectingMetrics(ssh);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.logger.debug(this.name + " finished applying load");
    }

    private final void applyLoad(SshConnection ssh, VirtualUserOptions options) {
        OpenJDK11 jdk = new OpenJDK11();
        jdk.install(ssh);
        VirtualUserOptions virtualUserOptions = options;
        String string = this.jarName;
        JavaDevelopmentKit javaDevelopmentKit = jdk;
        String testingCommand = new VirtualUsersJar().testingCommand(string, javaDevelopmentKit, virtualUserOptions);
        Duration duration = options.getBehavior().getLoad().getTotal().plus(options.getBehavior().getMaxOverhead());
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"options.behavior.load.to\u2026ions.behavior.maxOverhead");
        ssh.execute(testingCommand, duration);
    }

    private final void startCollectingMetrics(SshConnection ssh) {
        new Ubuntu().metrics(ssh);
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])new OsMetric[]{new Iostat(), new Vmstat(), new Pidstat.Builder().build()});
        for (Object element$iv : $receiver$iv) {
            OsMetric metric = (OsMetric)element$iv;
            this.monitoringProcesses.add(metric.start(ssh));
        }
    }

    private final void stopCollectingMetrics(SshConnection ssh) {
        Iterable $receiver$iv = this.monitoringProcesses;
        for (Object element$iv : $receiver$iv) {
            RemoteMonitoringProcess it = (RemoteMonitoringProcess)element$iv;
            it.stop(ssh);
        }
    }

    @Override
    public void gatherResults() {
        TaskTimer.INSTANCE.time("gather results from virtual users", (Function0)new Function0<Unit>(this){
            final /* synthetic */ SshVirtualUsers this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                String uploadDirectory = "results";
                String resultsDirectory = uploadDirectory + "/virtual-users/" + SshVirtualUsers.access$getName$p(this.this$0);
                Closeable closeable = (Closeable)this.this$0.getSsh().newConnection();
                Throwable throwable = null;
                try {
                    String string;
                    String it;
                    Collection<String> collection;
                    Iterable $receiver$iv$iv;
                    Iterable $receiver$iv;
                    SshConnection ssh = (SshConnection)closeable;
                    Iterable iterable = SshVirtualUsers.access$getMonitoringProcesses$p(this.this$0);
                    Collection collection2 = CollectionsKt.listOf((Object[])new String[]{"mkdir -p " + resultsDirectory, "mv test-results " + resultsDirectory, "mv diagnoses " + resultsDirectory, "mv virtual-users.log " + resultsDirectory, "mv virtual-users-out.log " + resultsDirectory, "mv virtual-users-error.log " + resultsDirectory, "cp /var/log/syslog " + resultsDirectory, "cp /var/log/cloud-init.log " + resultsDirectory, "cp /var/log/cloud-init-output.log " + resultsDirectory, "find " + resultsDirectory + " -empty -type f -delete"});
                    Iterator<T> iterator = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        RemoteMonitoringProcess remoteMonitoringProcess = (RemoteMonitoringProcess)item$iv$iv;
                        collection = destination$iv$iv;
                        string = it.getResultPath();
                        collection.add(string);
                    }
                    collection = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv = (Iterable)collection;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        it = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        string = "mv " + it + ' ' + resultsDirectory;
                        collection.add(string);
                    }
                    collection = (List)destination$iv$iv;
                    $receiver$iv = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
                    for (T element$iv : $receiver$iv) {
                        String it2 = (String)element$iv;
                        ssh.safeExecute(it2);
                    }
                    SshVirtualUsers.access$getResultsTransport$p(this.this$0).transportResults(uploadDirectory, ssh);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            {
                this.this$0 = sshVirtualUsers;
                super(0);
            }
        });
    }

    @NotNull
    public String toString() {
        return "SshVirtualUsers(name='" + this.name + "', nodeOrder=" + this.nodeOrder + ", resultsTransport=" + this.resultsTransport + ", jarName='" + this.jarName + "', ssh=" + this.ssh + ')';
    }

    @NotNull
    public final Ssh getSsh() {
        return this.ssh;
    }

    public SshVirtualUsers(@NotNull String name, int nodeOrder, @NotNull ResultsTransport resultsTransport, @NotNull String jarName, @NotNull Ssh ssh) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)resultsTransport, (String)"resultsTransport");
        Intrinsics.checkParameterIsNotNull((Object)jarName, (String)"jarName");
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        this.name = name;
        this.nodeOrder = nodeOrder;
        this.resultsTransport = resultsTransport;
        this.jarName = jarName;
        this.ssh = ssh;
        this.logger = LogManager.getLogger(this.getClass());
        SshVirtualUsers sshVirtualUsers = this;
        sshVirtualUsers.monitoringProcesses = list = (List)new ArrayList();
    }

    public /* synthetic */ SshVirtualUsers(String string, int n, ResultsTransport resultsTransport, String string2, Ssh ssh, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            String string3 = UUID.randomUUID().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"UUID.randomUUID().toString()");
            string = string3;
        }
        this(string, n, resultsTransport, string2, ssh);
    }

    @NotNull
    public static final /* synthetic */ String access$getName$p(SshVirtualUsers $this) {
        return $this.name;
    }

    @NotNull
    public static final /* synthetic */ List access$getMonitoringProcesses$p(SshVirtualUsers $this) {
        return $this.monitoringProcesses;
    }

    @NotNull
    public static final /* synthetic */ ResultsTransport access$getResultsTransport$p(SshVirtualUsers $this) {
        return $this.resultsTransport;
    }
}

