/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.virtualusers;

import com.atlassian.performance.tools.infrastructure.api.virtualusers.VirtualUsers;
import com.atlassian.performance.tools.io.api.DirectoriesKt;
import com.atlassian.performance.tools.virtualusers.api.EntryPointKt;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserOptions;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/LocalVirtualUsers;", "Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/VirtualUsers;", "workspace", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "applyLoad", "", "options", "Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserOptions;", "gatherResults", "useLog4jAutomaticConfiguration", "infrastructure"})
public final class LocalVirtualUsers
implements VirtualUsers {
    private final Path workspace;

    @Override
    public void applyLoad(@NotNull VirtualUserOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.useLog4jAutomaticConfiguration();
        EntryPointKt.main((String[])options.toCliArgs());
    }

    private final void useLog4jAutomaticConfiguration() {
        LogManager.getLogger(this.getClass());
    }

    @Override
    public void gatherResults() {
        Path results = this.workspace.resolve("virtual-users").resolve("local");
        Path workDir = FileSystems.getDefault().getPath(".", new String[0]).toAbsolutePath();
        List filesToMove = CollectionsKt.listOf((Object[])new String[]{"test-results", "diagnoses"});
        Iterable $receiver$iv = filesToMove;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            Path path = results.resolve(it);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"results.resolve(it)");
            DirectoriesKt.ensureDirectory((Path)path);
            if (!workDir.resolve(it).toFile().exists()) continue;
            Files.move(workDir.resolve(it), results.resolve(it), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public LocalVirtualUsers(@NotNull Path workspace) {
        Intrinsics.checkParameterIsNotNull((Object)workspace, (String)"workspace");
        this.workspace = workspace;
    }
}

