/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.virtualusers;

import com.atlassian.performance.tools.infrastructure.api.virtualusers.ResultsTransport;
import com.atlassian.performance.tools.io.api.DirectoriesKt;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/DirectResultsTransport;", "Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/ResultsTransport;", "localDestination", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "toString", "", "transportResults", "", "targetDirectory", "sshConnection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "infrastructure"})
public final class DirectResultsTransport
implements ResultsTransport {
    private final Logger logger;
    private final Path localDestination;

    @Override
    public void transportResults(@NotNull String targetDirectory, @NotNull SshConnection sshConnection) {
        Intrinsics.checkParameterIsNotNull((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkParameterIsNotNull((Object)sshConnection, (String)"sshConnection");
        this.logger.info("Downloading results to " + this.localDestination);
        File file = this.localDestination.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"localDestination.toFile()");
        DirectoriesKt.ensureParentDirectory((File)file);
        sshConnection.download(targetDirectory + "/*", this.localDestination);
    }

    @NotNull
    public String toString() {
        return "DirectResultsTransport(localDestination=" + this.localDestination + ", logger=" + this.logger + ')';
    }

    public DirectResultsTransport(@NotNull Path localDestination) {
        Intrinsics.checkParameterIsNotNull((Object)localDestination, (String)"localDestination");
        this.localDestination = localDestination;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }
}

