/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.splunk;

import com.atlassian.performance.tools.infrastructure.api.docker.DockerContainer;
import com.atlassian.performance.tools.infrastructure.api.splunk.LogStashConfigBuilder;
import com.atlassian.performance.tools.infrastructure.api.splunk.SplunkForwarder;
import com.atlassian.performance.tools.infrastructure.splunk.Log4jJsonifier;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/splunk/AtlassianSplunkForwarder;", "Lcom/atlassian/performance/tools/infrastructure/api/splunk/SplunkForwarder;", "additionalEventFields", "", "", "kinesisRoleArn", "(Ljava/util/Map;Ljava/lang/String;)V", "getRequiredPorts", "", "", "jsonifyLog4j", "", "sshConnection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "log4jPropertiesPath", "run", "name", "logsPath", "infrastructure"})
public final class AtlassianSplunkForwarder
implements SplunkForwarder {
    private final Map<String, String> additionalEventFields;
    private final String kinesisRoleArn;

    @Override
    public void run(@NotNull SshConnection sshConnection, @NotNull String name, @NotNull String logsPath) {
        Intrinsics.checkParameterIsNotNull((Object)sshConnection, (String)"sshConnection");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)logsPath, (String)"logsPath");
        String logstashConfFilePath = "~/logstash.conf";
        sshConnection.execute(StringsKt.trimMargin$default((String)("cat > " + logstashConfFilePath + " <<'EOF'\n        |" + new LogStashConfigBuilder(this.additionalEventFields, this.kinesisRoleArn).build() + "\n        |EOF"), null, (int)1, null));
        DockerContainer.Builder builder = new DockerContainer.Builder().imageName("docker.elastic.co/logstash/logstash-oss:6.2.4");
        Duration duration = Duration.ofMinutes(5L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(5)");
        builder.pullTimeout(duration).parameters("--volume " + logsPath + ":/usr/share/logstash/pipeline/", "--volume /var/lib/docker/containers:/host/containers:ro", "--volume /var/run/docker.sock:/var/run/docker.sock:ro", "-v " + logstashConfFilePath + ":/usr/share/logstash/config/logstash.conf").arguments("sh -c \"logstash-plugin install logstash-output-kinesis;", "bin/logstash -f /usr/share/logstash/config/logstash.conf --config.reload.automatic;", "/usr/local/bin/docker-entrypoint\"").build().run(sshConnection);
    }

    @Override
    public void jsonifyLog4j(@NotNull SshConnection sshConnection, @NotNull String log4jPropertiesPath) {
        Intrinsics.checkParameterIsNotNull((Object)sshConnection, (String)"sshConnection");
        Intrinsics.checkParameterIsNotNull((Object)log4jPropertiesPath, (String)"log4jPropertiesPath");
        new Log4jJsonifier().jsonifyLog4j1(sshConnection, log4jPropertiesPath);
    }

    @Override
    @NotNull
    public List<Integer> getRequiredPorts() {
        return CollectionsKt.emptyList();
    }

    public AtlassianSplunkForwarder(@NotNull Map<String, String> additionalEventFields, @NotNull String kinesisRoleArn) {
        Intrinsics.checkParameterIsNotNull(additionalEventFields, (String)"additionalEventFields");
        Intrinsics.checkParameterIsNotNull((Object)kinesisRoleArn, (String)"kinesisRoleArn");
        this.additionalEventFields = additionalEventFields;
        this.kinesisRoleArn = kinesisRoleArn;
    }
}

