/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.os;

import com.atlassian.performance.tools.infrastructure.api.os.MonitoringProcess;
import com.atlassian.performance.tools.infrastructure.api.os.OsMetric;
import com.atlassian.performance.tools.infrastructure.api.process.RemoteMonitoringProcess;
import com.atlassian.performance.tools.ssh.api.DetachedProcess;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/os/Vmstat;", "Lcom/atlassian/performance/tools/infrastructure/api/os/OsMetric;", "()V", "start", "Lcom/atlassian/performance/tools/infrastructure/api/process/RemoteMonitoringProcess;", "connection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "startMonitoring", "Lcom/atlassian/performance/tools/infrastructure/api/os/MonitoringProcess;", "Companion", "infrastructure"})
public final class Vmstat
implements OsMetric {
    @NotNull
    private static final String LOG_FILE_NAME = "jpt-vmstat.log";
    private static final String LOG_PATH = "~/jpt-vmstat.log";
    private static final Duration DELAY;
    public static final Companion Companion;

    @Override
    @NotNull
    public MonitoringProcess startMonitoring(@NotNull SshConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        long delayInSeconds = DELAY.get(ChronoUnit.SECONDS);
        DetachedProcess process = connection.startProcess("vmstat -t " + delayInSeconds + " > " + LOG_PATH);
        return new MonitoringProcess(process, LOG_PATH);
    }

    @Override
    @NotNull
    public RemoteMonitoringProcess start(@NotNull SshConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        long delayInSeconds = DELAY.get(ChronoUnit.SECONDS);
        DetachedProcess process = connection.startProcess("vmstat -t " + delayInSeconds + " > " + LOG_PATH);
        return new MonitoringProcess(process, LOG_PATH);
    }

    static {
        Companion = new Companion(null);
        LOG_FILE_NAME = LOG_FILE_NAME;
        LOG_PATH = "~/" + LOG_FILE_NAME;
        Duration duration = Duration.ofSeconds(2L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(2)");
        DELAY = duration;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/os/Vmstat$Companion;", "", "()V", "DELAY", "Ljava/time/Duration;", "LOG_FILE_NAME", "", "getLOG_FILE_NAME", "()Ljava/lang/String;", "LOG_PATH", "infrastructure"})
    public static final class Companion {
        @NotNull
        public final String getLOG_FILE_NAME() {
            return LOG_FILE_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

