/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.os;

import com.atlassian.performance.tools.infrastructure.api.os.OsMetric;
import com.atlassian.performance.tools.infrastructure.api.os.Ubuntu;
import com.atlassian.performance.tools.infrastructure.api.os.Vmstat;
import com.atlassian.performance.tools.infrastructure.os.Iostat;
import com.atlassian.performance.tools.jvmtasks.api.Backoff;
import com.atlassian.performance.tools.jvmtasks.api.BackoffKt;
import com.atlassian.performance.tools.jvmtasks.api.IdempotentAction;
import com.atlassian.performance.tools.jvmtasks.api.JitterBackoff;
import com.atlassian.performance.tools.jvmtasks.api.StaticBackoff;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import com.atlassian.performance.tools.ssh.api.SshHost;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.jcip.annotations.ThreadSafe;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0007J\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u0017\u001a\u00020\u0006J&\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u001a\u001a\u00020\u0004*\u00020\u00062\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u001cH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/os/Ubuntu;", "", "()V", "addKey", "", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "keyId", "", "addRemoteKey", "keyUrl", "addRepository", "repository", "sourceFileName", "cleanInterruptedApt", "getDistributionCodename", "install", "packages", "", "timeout", "Ljava/time/Duration;", "metrics", "Lcom/atlassian/performance/tools/infrastructure/api/os/OsMetric;", "connection", "tryInstalling", "updatePackageIndex", "lockApt", "lambda", "Lkotlin/Function1;", "Companion", "infrastructure"})
public final class Ubuntu {
    private static final ConcurrentHashMap<String, Object> LOCKS;
    @Deprecated
    public static final Companion Companion;

    public final void install(@NotNull SshConnection ssh, @NotNull List<String> packages, @NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull(packages, (String)"packages");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        IdempotentAction idempotentAction = new IdempotentAction("install " + packages, (Function0)new Function0<Unit>(this, ssh, packages, timeout){
            final /* synthetic */ Ubuntu this$0;
            final /* synthetic */ SshConnection $ssh;
            final /* synthetic */ List $packages;
            final /* synthetic */ Duration $timeout;

            public final void invoke() {
                Ubuntu.access$tryInstalling(this.this$0, this.$ssh, this.$packages, this.$timeout);
            }
            {
                this.this$0 = ubuntu;
                this.$ssh = sshConnection;
                this.$packages = list;
                this.$timeout = duration;
                super(0);
            }
        });
        Duration duration = Duration.ofSeconds(10L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ofSeconds(10)");
        Backoff backoff = (Backoff)new StaticBackoff(duration);
        Duration duration2 = Duration.ofSeconds(5L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"ofSeconds(5)");
        idempotentAction.retry(7, BackoffKt.plus((Backoff)backoff, (Backoff)((Backoff)new JitterBackoff(duration2))));
    }

    public static /* bridge */ /* synthetic */ void install$default(Ubuntu ubuntu, SshConnection sshConnection, List list, Duration duration, int n, Object object) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofMinutes(1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMinutes(1)");
            duration = duration2;
        }
        ubuntu.install(sshConnection, list, duration);
    }

    private final void tryInstalling(SshConnection ssh, List<String> packages, Duration timeout) {
        String joinedPackages = CollectionsKt.joinToString$default((Iterable)packages, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        try {
            this.updatePackageIndex(ssh);
            this.lockApt(ssh, (Function1<? super SshConnection, Unit>)((Function1)new Function1<SshConnection, Unit>(joinedPackages, timeout){
                final /* synthetic */ String $joinedPackages;
                final /* synthetic */ Duration $timeout;

                public final void invoke(@NotNull SshConnection it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    String string = "sudo DEBIAN_FRONTEND=noninteractive apt-get install -qq " + this.$joinedPackages;
                    Level level = Level.TRACE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.TRACE");
                    Level level2 = Level.TRACE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.TRACE");
                    it.execute(string, this.$timeout, level, level2);
                }
                {
                    this.$joinedPackages = string;
                    this.$timeout = duration;
                    super(1);
                }
            }));
        }
        catch (Exception e) {
            this.cleanInterruptedApt(ssh);
            throw (Throwable)new Exception("Failed an attempt to install " + packages, e);
        }
    }

    private final void cleanInterruptedApt(SshConnection ssh) {
        this.lockApt(ssh, (Function1<? super SshConnection, Unit>)((Function1)new Function1<SshConnection, Unit>(ssh){
            final /* synthetic */ SshConnection $ssh;

            public final void invoke(@NotNull SshConnection it) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String string2 = string = this.$ssh.safeExecute("pidof apt-get").getOutput();
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                Integer pid = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)string2)).toString());
                if (pid != null) {
                    it.safeExecute("kill -9 " + pid);
                    it.execute("sudo rm -rf /var/lib/apt/lists/*");
                    it.execute("sudo rm -rf /var/lib/dpkg/updates/*");
                }
            }
            {
                this.$ssh = sshConnection;
                super(1);
            }
        }));
    }

    @NotNull
    public final List<OsMetric> metrics(@NotNull SshConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        Ubuntu.install$default(this, connection, CollectionsKt.listOf((Object)"sysstat"), null, 4, null);
        return CollectionsKt.listOf((Object[])new OsMetric[]{new Vmstat(), new Iostat()});
    }

    private final void updatePackageIndex(SshConnection ssh) {
        this.lockApt(ssh, (Function1<? super SshConnection, Unit>)((Function1)updatePackageIndex.1.INSTANCE));
    }

    public final void addKey(@NotNull SshConnection ssh, @NotNull String keyId) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)keyId, (String)"keyId");
        this.lockApt(ssh, (Function1<? super SshConnection, Unit>)((Function1)new Function1<SshConnection, Unit>(keyId){
            final /* synthetic */ String $keyId;

            public final void invoke(@NotNull SshConnection it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.execute("sudo apt-key adv --keyserver keyserver.ubuntu.com --recv-keys " + this.$keyId + " 2>&1 | grep -v 'stdout is not a terminal'");
            }
            {
                this.$keyId = string;
                super(1);
            }
        }));
    }

    public final void addRemoteKey(@NotNull SshConnection ssh, @NotNull String keyUrl) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)keyUrl, (String)"keyUrl");
        this.lockApt(ssh, (Function1<? super SshConnection, Unit>)((Function1)new Function1<SshConnection, Unit>(keyUrl){
            final /* synthetic */ String $keyUrl;

            public final void invoke(@NotNull SshConnection it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.execute("wget -q -O - " + this.$keyUrl + " | sudo apt-key add -");
            }
            {
                this.$keyUrl = string;
                super(1);
            }
        }));
    }

    @kotlin.Deprecated(message="Use the version with declared file name instead", replaceWith=@ReplaceWith(imports={}, expression="addRepository()"))
    public final void addRepository(@NotNull SshConnection ssh, @NotNull String repository) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Ubuntu.install$default(this, ssh, CollectionsKt.listOf((Object)"software-properties-common"), null, 4, null);
        this.lockApt(ssh, (Function1<? super SshConnection, Unit>)((Function1)new Function1<SshConnection, Unit>(repository){
            final /* synthetic */ String $repository;

            public final void invoke(@NotNull SshConnection it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.execute("sudo add-apt-repository '" + this.$repository + '\'');
            }
            {
                this.$repository = string;
                super(1);
            }
        }));
    }

    public final void addRepository(@NotNull SshConnection ssh, @NotNull String repository, @NotNull String sourceFileName) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)sourceFileName, (String)"sourceFileName");
        this.lockApt(ssh, (Function1<? super SshConnection, Unit>)((Function1)new Function1<SshConnection, Unit>(repository, sourceFileName){
            final /* synthetic */ String $repository;
            final /* synthetic */ String $sourceFileName;

            public final void invoke(@NotNull SshConnection it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.execute("echo '" + this.$repository + "' | sudo tee /etc/apt/sources.list.d/" + this.$sourceFileName + ".list");
            }
            {
                this.$repository = string;
                this.$sourceFileName = string2;
                super(1);
            }
        }));
        this.updatePackageIndex(ssh);
    }

    @NotNull
    public final String getDistributionCodename(@NotNull SshConnection ssh) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        return StringsKt.trimEnd((String)ssh.execute(". /etc/lsb-release ; echo $DISTRIB_CODENAME").getOutput(), (char[])new char[]{'\n'});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void lockApt(@NotNull SshConnection $receiver, Function1<? super SshConnection, Unit> lambda2) {
        Object lock2;
        SshHost host = $receiver.getHost();
        String lockId = host.getIpAddress() + host.getPort();
        Object object = lock2 = LOCKS.computeIfAbsent(lockId, lockApt.lock.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"lock");
        Object object2 = object;
        synchronized (object2) {
            lambda2.invoke((Object)$receiver);
            Unit unit = Unit.INSTANCE;
        }
    }

    static {
        Companion = new Companion(null);
        LOCKS = new ConcurrentHashMap();
    }

    public static final /* synthetic */ void access$tryInstalling(Ubuntu $this, @NotNull SshConnection ssh, @NotNull List packages, @NotNull Duration timeout) {
        $this.tryInstalling(ssh, packages, timeout);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/os/Ubuntu$Companion;", "", "()V", "LOCKS", "Ljava/util/concurrent/ConcurrentHashMap;", "", "infrastructure"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

