/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.jvm;

import com.atlassian.performance.tools.infrastructure.api.jvm.JavaDevelopmentKit;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/jvm/ThreadDump;", "", "pid", "", "jdk", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/JavaDevelopmentKit;", "(ILcom/atlassian/performance/tools/infrastructure/api/jvm/JavaDevelopmentKit;)V", "gather", "", "connection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "destination", "", "infrastructure"})
public final class ThreadDump {
    private final int pid;
    private final JavaDevelopmentKit jdk;

    public final void gather(@NotNull SshConnection connection, @NotNull String destination) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        long threadDumpName = Instant.now().toEpochMilli();
        String command = this.jdk.use() + "; jcmd " + this.pid + " Thread.print > " + destination + '/' + threadDumpName;
        connection.execute("mkdir -p " + destination);
        connection.execute(command);
    }

    public ThreadDump(int pid, @NotNull JavaDevelopmentKit jdk) {
        Intrinsics.checkParameterIsNotNull((Object)jdk, (String)"jdk");
        this.pid = pid;
        this.jdk = jdk;
    }
}

