/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.jvm;

import com.atlassian.performance.tools.infrastructure.api.jvm.JdkFonts;
import com.atlassian.performance.tools.infrastructure.api.jvm.Jstat;
import com.atlassian.performance.tools.infrastructure.api.jvm.VersionedJavaDevelopmentKit;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.net.URI;
import java.time.Duration;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/jvm/OracleJDK;", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/VersionedJavaDevelopmentKit;", "()V", "bin", "", "jdkArchive", "jdkUpdate", "", "jdkUrl", "Ljava/net/URI;", "kotlin.jvm.PlatformType", "jreBin", "jstat", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/Jstat;", "jstat$annotations", "getJstat", "()Lcom/atlassian/performance/tools/infrastructure/api/jvm/Jstat;", "jstatMonitoring", "getJstatMonitoring", "logger", "Lorg/apache/logging/log4j/Logger;", "path", "command", "options", "download", "", "connection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "getMajorVersion", "install", "use", "infrastructure"})
public final class OracleJDK
implements VersionedJavaDevelopmentKit {
    private final Logger logger;
    private final int jdkUpdate = 131;
    private final String jdkArchive = "jdk-8u131-linux-x64.tar.gz";
    private final URI jdkUrl;
    private final String path = "~/jdk1.8.0_131";
    private final String jreBin = "~/jdk1.8.0_131/jre/bin/";
    private final String bin = "~/jdk1.8.0_131/bin/";
    @NotNull
    private final Jstat jstatMonitoring;
    @NotNull
    private final Jstat jstat;

    @Override
    @NotNull
    public Jstat getJstatMonitoring() {
        return this.jstatMonitoring;
    }

    @Deprecated(message="Use JavaDevelopmentKit.jstatMonitoring instead.", replaceWith=@ReplaceWith(imports={}, expression="jstatMonitoring"))
    public static /* synthetic */ void jstat$annotations() {
    }

    @NotNull
    public final Jstat getJstat() {
        return this.jstat;
    }

    @Override
    public int getMajorVersion() {
        return 8;
    }

    @Override
    public void install(@NotNull SshConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        this.download(connection);
        connection.execute("tar -xzf " + this.jdkArchive);
        connection.execute("echo '" + this.use() + "' >> ~/.profile");
        new JdkFonts().install(connection);
    }

    @Override
    @NotNull
    public String use() {
        return "export PATH=" + this.jreBin + ':' + this.bin + ":$PATH; export JAVA_HOME=" + this.path;
    }

    @Override
    @NotNull
    public String command(@NotNull String options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        return this.jreBin + "java " + options;
    }

    /*
     * WARNING - void declaration
     */
    private final void download(SshConnection connection) {
        int n;
        IntRange attempts;
        int n2 = 0;
        IntRange intRange = attempts = new IntRange(n2, 3);
        n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                try {
                    String string = "curl --silent --location --remote-name --cookie 'oraclelicense=a' " + this.jdkUrl;
                    Duration duration = Duration.ofSeconds(120L);
                    Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(120)");
                    connection.execute(string, duration);
                }
                catch (Exception e) {
                    void attempt;
                    this.logger.debug("Attempt #" + (int)attempt + " to download Oracle JDK failed");
                    if (attempt == attempts.getLast()) {
                        throw (Throwable)new Exception("Failed to download Oracle JDK despite " + (int)attempt + " attempts", e);
                    }
                    if (attempt == n) break;
                    ++attempt;
                    continue;
                }
                break;
            }
        }
    }

    public OracleJDK() {
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.jdkUpdate = 131;
        this.jdkArchive = "jdk-8u" + this.jdkUpdate + "-linux-x64.tar.gz";
        this.jdkUrl = URI.create("https://download.oracle.com/otn-pub/java/jdk/8u" + this.jdkUpdate + "-b11/d54c1d3a095b4ff2b6607d096fa80163/" + this.jdkArchive);
        this.path = "~/jdk1.8.0_" + this.jdkUpdate;
        this.jreBin = this.path + "/jre/bin/";
        this.bin = this.path + "/bin/";
        this.jstatMonitoring = new Jstat(this.bin);
        this.jstat = this.getJstatMonitoring();
    }
}

