/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.jvm;

import com.atlassian.performance.tools.infrastructure.api.os.MonitoringProcess;
import com.atlassian.performance.tools.infrastructure.api.process.RemoteMonitoringProcess;
import com.atlassian.performance.tools.ssh.api.DetachedProcess;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Duration;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0003H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/jvm/Jstat;", "", "jvmBin", "", "(Ljava/lang/String;)V", "start", "Lcom/atlassian/performance/tools/infrastructure/api/process/RemoteMonitoringProcess;", "connection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "pid", "", "option", "startMonitoring", "Lcom/atlassian/performance/tools/infrastructure/api/os/MonitoringProcess;", "Companion", "infrastructure"})
public final class Jstat {
    private final String jvmBin;
    @NotNull
    private static final String LOG_FILE_NAME = "jpt-jstat.log";
    private static final Duration INTERVAL;
    private static final String LOG_PATH = "~/jpt-jstat.log";
    private static final String TIME = "date -Iseconds";
    private static final String ADD_TIME = "while IFS= read -r line; do echo \"$(date -Iseconds) $line\"; done";
    public static final Companion Companion;

    @Deprecated(message="Use `start` method.")
    @NotNull
    public final MonitoringProcess startMonitoring(@NotNull SshConnection connection, @NotNull String pid, @NotNull String option) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)pid, (String)"pid");
        Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
        String interval = "" + INTERVAL.getSeconds() + 's';
        DetachedProcess process = connection.startProcess(this.jvmBin + "jstat " + option + " -t " + pid + ' ' + interval + " | " + ADD_TIME + " > " + LOG_PATH);
        return new MonitoringProcess(process, LOG_PATH);
    }

    @Deprecated(message="Use `start` method.")
    @NotNull
    public static /* bridge */ /* synthetic */ MonitoringProcess startMonitoring$default(Jstat jstat, SshConnection sshConnection, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "-gcutil";
        }
        return jstat.startMonitoring(sshConnection, string, string2);
    }

    @NotNull
    public final RemoteMonitoringProcess start(@NotNull SshConnection connection, int pid) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        String option = "-gcutil";
        return this.start(connection, pid, option);
    }

    @NotNull
    public final RemoteMonitoringProcess start(@NotNull SshConnection connection, int pid, @NotNull String option) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
        String interval = "" + INTERVAL.getSeconds() + 's';
        DetachedProcess process = connection.startProcess(this.jvmBin + "jstat " + option + " -t " + pid + ' ' + interval + " | " + ADD_TIME + " > " + LOG_PATH);
        return new MonitoringProcess(process, LOG_PATH);
    }

    public Jstat(@NotNull String jvmBin) {
        Intrinsics.checkParameterIsNotNull((Object)jvmBin, (String)"jvmBin");
        this.jvmBin = jvmBin;
    }

    static {
        Companion = new Companion(null);
        LOG_FILE_NAME = LOG_FILE_NAME;
        Duration duration = Duration.ofSeconds(2L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(2)");
        INTERVAL = duration;
        LOG_PATH = "~/" + LOG_FILE_NAME;
        TIME = TIME;
        ADD_TIME = "while IFS= read -r line; do " + "echo \"$(" + TIME + ") $line\"; " + "done";
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/jvm/Jstat$Companion;", "", "()V", "ADD_TIME", "", "INTERVAL", "Ljava/time/Duration;", "LOG_FILE_NAME", "getLOG_FILE_NAME", "()Ljava/lang/String;", "LOG_PATH", "TIME", "infrastructure"})
    public static final class Companion {
        @NotNull
        public final String getLOG_FILE_NAME() {
            return LOG_FILE_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

