/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.docker;

import com.atlassian.performance.tools.infrastructure.Docker;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Duration;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/docker/DockerContainer;", "", "runtime", "Lcom/atlassian/performance/tools/infrastructure/Docker;", "imageName", "", "pullTimeout", "Ljava/time/Duration;", "containerName", "parameters", "arguments", "(Lcom/atlassian/performance/tools/infrastructure/Docker;Ljava/lang/String;Ljava/time/Duration;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "run", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "Builder", "infrastructure"})
public final class DockerContainer {
    private final Docker runtime;
    private final String imageName;
    private final Duration pullTimeout;
    private final String containerName;
    private final String parameters;
    private final String arguments;

    @NotNull
    public final String run(@NotNull SshConnection ssh) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        this.runtime.install(ssh);
        String string = "sudo docker pull " + this.imageName;
        Level level = Level.TRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.TRACE");
        Level level2 = Level.WARN;
        Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.WARN");
        ssh.execute(string, this.pullTimeout, level, level2);
        ssh.execute("sudo docker run -d " + this.parameters + " --name " + this.containerName + ' ' + this.imageName + ' ' + this.arguments);
        return this.containerName;
    }

    private DockerContainer(Docker runtime, String imageName, Duration pullTimeout, String containerName, String parameters, String arguments) {
        this.runtime = runtime;
        this.imageName = imageName;
        this.pullTimeout = pullTimeout;
        this.containerName = containerName;
        this.parameters = parameters;
        this.arguments = arguments;
    }

    public /* synthetic */ DockerContainer(@NotNull Docker runtime, @NotNull String imageName, @NotNull Duration pullTimeout, @NotNull String containerName, @NotNull String parameters, @NotNull String arguments, DefaultConstructorMarker $constructor_marker) {
        this(runtime, imageName, pullTimeout, containerName, parameters, arguments);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00002\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\f\"\u00020\u0004\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0004J\u001f\u0010\u0007\u001a\u00020\u00002\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\f\"\u00020\u0004\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/docker/DockerContainer$Builder;", "", "()V", "arguments", "", "containerName", "imageName", "parameters", "pullTimeout", "Ljava/time/Duration;", "runtime", "Lcom/atlassian/performance/tools/infrastructure/Docker;", "", "([Ljava/lang/String;)Lcom/atlassian/performance/tools/infrastructure/api/docker/DockerContainer$Builder;", "build", "Lcom/atlassian/performance/tools/infrastructure/api/docker/DockerContainer;", "infrastructure"})
    public static final class Builder {
        private final Docker runtime = new Docker();
        private String imageName = "ubuntu:latest";
        private Duration pullTimeout;
        private String containerName;
        private String parameters;
        private String arguments;

        @NotNull
        public final Builder imageName(@NotNull String imageName) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)imageName, (String)"imageName");
            Builder $receiver = builder = this;
            $receiver.imageName = imageName;
            return builder;
        }

        @NotNull
        public final Builder pullTimeout(@NotNull Duration pullTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)pullTimeout, (String)"pullTimeout");
            Builder $receiver = builder = this;
            $receiver.pullTimeout = pullTimeout;
            return builder;
        }

        @NotNull
        public final Builder containerName(@NotNull String containerName) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)containerName, (String)"containerName");
            Builder $receiver = builder = this;
            $receiver.containerName = containerName;
            return builder;
        }

        @NotNull
        public final Builder parameters(@NotNull String parameters) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
            Builder $receiver = builder = this;
            $receiver.parameters = parameters;
            return builder;
        }

        @NotNull
        public final Builder parameters(String ... parameters) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
            Builder $receiver = builder = this;
            $receiver.parameters = ArraysKt.joinToString$default((Object[])parameters, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            return builder;
        }

        @NotNull
        public final Builder arguments(@NotNull String arguments) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
            Builder $receiver = builder = this;
            $receiver.arguments = arguments;
            return builder;
        }

        @NotNull
        public final Builder arguments(String ... arguments) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
            Builder $receiver = builder = this;
            $receiver.arguments = ArraysKt.joinToString$default((Object[])arguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            return builder;
        }

        @NotNull
        public final DockerContainer build() {
            return new DockerContainer(this.runtime, this.imageName, this.pullTimeout, this.containerName, this.parameters, this.arguments, null);
        }

        public Builder() {
            Duration duration = Duration.ofMinutes(1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(1)");
            this.pullTimeout = duration;
            this.containerName = "jpt-" + UUID.randomUUID();
            this.parameters = "";
            this.arguments = "";
        }
    }
}

