/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.database.passwordoverride;

import com.atlassian.performance.tools.infrastructure.api.database.Database;
import com.atlassian.performance.tools.infrastructure.api.database.passwordoverride.CrowdEncryptedPasswordProvider;
import com.atlassian.performance.tools.infrastructure.api.database.passwordoverride.JiraUserEncryptedPasswordProvider;
import com.atlassian.performance.tools.infrastructure.database.SshMysqlClient;
import com.atlassian.performance.tools.infrastructure.database.SshSqlClient;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/database/passwordoverride/JiraUserPasswordOverridingDatabase;", "Lcom/atlassian/performance/tools/infrastructure/api/database/Database;", "databaseDelegate", "sqlClient", "Lcom/atlassian/performance/tools/infrastructure/database/SshSqlClient;", "username", "", "schema", "userPasswordPlainText", "jiraUserEncryptedPasswordProvider", "Lcom/atlassian/performance/tools/infrastructure/api/database/passwordoverride/JiraUserEncryptedPasswordProvider;", "(Lcom/atlassian/performance/tools/infrastructure/api/database/Database;Lcom/atlassian/performance/tools/infrastructure/database/SshSqlClient;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/atlassian/performance/tools/infrastructure/api/database/passwordoverride/JiraUserEncryptedPasswordProvider;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "setup", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "start", "", "jira", "Ljava/net/URI;", "Builder", "infrastructure"})
public final class JiraUserPasswordOverridingDatabase
implements Database {
    private final Logger logger;
    private final Database databaseDelegate;
    private final SshSqlClient sqlClient;
    private final String username;
    private final String schema;
    private final String userPasswordPlainText;
    private final JiraUserEncryptedPasswordProvider jiraUserEncryptedPasswordProvider;

    @Override
    @NotNull
    public String setup(@NotNull SshConnection ssh) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        return this.databaseDelegate.setup(ssh);
    }

    @Override
    public void start(@NotNull URI jira, @NotNull SshConnection ssh) {
        Intrinsics.checkParameterIsNotNull((Object)jira, (String)"jira");
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        this.databaseDelegate.start(jira, ssh);
        String password = this.jiraUserEncryptedPasswordProvider.getEncryptedPassword(ssh);
        this.sqlClient.runSql(ssh, "UPDATE " + this.schema + ".cwd_user SET credential='" + password + "' WHERE user_name='" + this.username + "';");
        this.logger.debug("Password for user '" + this.username + "' updated to '" + this.userPasswordPlainText + '\'');
    }

    private JiraUserPasswordOverridingDatabase(Database databaseDelegate, SshSqlClient sqlClient, String username, String schema, String userPasswordPlainText, JiraUserEncryptedPasswordProvider jiraUserEncryptedPasswordProvider) {
        this.databaseDelegate = databaseDelegate;
        this.sqlClient = sqlClient;
        this.username = username;
        this.schema = schema;
        this.userPasswordPlainText = userPasswordPlainText;
        this.jiraUserEncryptedPasswordProvider = jiraUserEncryptedPasswordProvider;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    public /* synthetic */ JiraUserPasswordOverridingDatabase(@NotNull Database databaseDelegate, @NotNull SshSqlClient sqlClient, @NotNull String username, @NotNull String schema, @NotNull String userPasswordPlainText, @NotNull JiraUserEncryptedPasswordProvider jiraUserEncryptedPasswordProvider, DefaultConstructorMarker $constructor_marker) {
        this(databaseDelegate, sqlClient, username, schema, userPasswordPlainText, jiraUserEncryptedPasswordProvider);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/database/passwordoverride/JiraUserPasswordOverridingDatabase$Builder;", "", "databaseDelegate", "Lcom/atlassian/performance/tools/infrastructure/api/database/Database;", "plainTextPassword", "", "passwordEncrypted", "(Lcom/atlassian/performance/tools/infrastructure/api/database/Database;Ljava/lang/String;Ljava/lang/String;)V", "jiraUserEncryptedPasswordProvider", "Lcom/atlassian/performance/tools/infrastructure/api/database/passwordoverride/JiraUserEncryptedPasswordProvider;", "schema", "sqlClient", "Lcom/atlassian/performance/tools/infrastructure/database/SshSqlClient;", "username", "build", "Lcom/atlassian/performance/tools/infrastructure/api/database/passwordoverride/JiraUserPasswordOverridingDatabase;", "userPasswordEncrypted", "userPasswordPlainText", "jiraDatabaseSchemaName", "infrastructure"})
    public static final class Builder {
        private SshSqlClient sqlClient;
        private String schema;
        private String username;
        private JiraUserEncryptedPasswordProvider jiraUserEncryptedPasswordProvider;
        private Database databaseDelegate;
        private String plainTextPassword;
        private String passwordEncrypted;

        @NotNull
        public final Builder databaseDelegate(@NotNull Database databaseDelegate) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)databaseDelegate, (String)"databaseDelegate");
            Builder $receiver = builder = this;
            $receiver.databaseDelegate = databaseDelegate;
            return builder;
        }

        @NotNull
        public final Builder username(@NotNull String username) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
            Builder $receiver = builder = this;
            $receiver.username = username;
            return builder;
        }

        @NotNull
        public final Builder plainTextPassword(@NotNull String userPasswordPlainText) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)userPasswordPlainText, (String)"userPasswordPlainText");
            Builder $receiver = builder = this;
            $receiver.plainTextPassword = userPasswordPlainText;
            return builder;
        }

        @NotNull
        public final Builder passwordEncrypted(@NotNull String userPasswordEncrypted) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)userPasswordEncrypted, (String)"userPasswordEncrypted");
            Builder $receiver = builder = this;
            $receiver.passwordEncrypted = userPasswordEncrypted;
            return builder;
        }

        @NotNull
        public final Builder sqlClient(@NotNull SshSqlClient sqlClient) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)sqlClient, (String)"sqlClient");
            Builder $receiver = builder = this;
            $receiver.sqlClient = sqlClient;
            return builder;
        }

        @NotNull
        public final Builder schema(@NotNull String jiraDatabaseSchemaName) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jiraDatabaseSchemaName, (String)"jiraDatabaseSchemaName");
            Builder $receiver = builder = this;
            $receiver.schema = jiraDatabaseSchemaName;
            return builder;
        }

        @NotNull
        public final Builder jiraUserEncryptedPasswordProvider(@NotNull JiraUserEncryptedPasswordProvider jiraUserEncryptedPasswordProvider) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jiraUserEncryptedPasswordProvider, (String)"jiraUserEncryptedPasswordProvider");
            Builder $receiver = builder = this;
            $receiver.jiraUserEncryptedPasswordProvider = jiraUserEncryptedPasswordProvider;
            return builder;
        }

        @NotNull
        public final JiraUserPasswordOverridingDatabase build() {
            JiraUserEncryptedPasswordProvider jiraUserEncryptedPasswordProvider = this.jiraUserEncryptedPasswordProvider;
            if (jiraUserEncryptedPasswordProvider == null) {
                jiraUserEncryptedPasswordProvider = new CrowdEncryptedPasswordProvider(this.schema, this.plainTextPassword, this.passwordEncrypted, this.sqlClient);
            }
            JiraUserEncryptedPasswordProvider jiraUserEncryptedPasswordProvider2 = jiraUserEncryptedPasswordProvider;
            String string = this.schema;
            String string2 = this.plainTextPassword;
            return new JiraUserPasswordOverridingDatabase(this.databaseDelegate, this.sqlClient, this.username, string, string2, jiraUserEncryptedPasswordProvider2, null);
        }

        public Builder(@NotNull Database databaseDelegate, @NotNull String plainTextPassword, @NotNull String passwordEncrypted) {
            Intrinsics.checkParameterIsNotNull((Object)databaseDelegate, (String)"databaseDelegate");
            Intrinsics.checkParameterIsNotNull((Object)plainTextPassword, (String)"plainTextPassword");
            Intrinsics.checkParameterIsNotNull((Object)passwordEncrypted, (String)"passwordEncrypted");
            this.databaseDelegate = databaseDelegate;
            this.plainTextPassword = plainTextPassword;
            this.passwordEncrypted = passwordEncrypted;
            this.sqlClient = new SshMysqlClient();
            this.schema = "jiradb";
            this.username = "admin";
        }
    }
}

