/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.database.passwordoverride;

import com.atlassian.performance.tools.infrastructure.api.database.passwordoverride.JiraUserEncryptedPasswordProvider;
import com.atlassian.performance.tools.infrastructure.database.SshSqlClient;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/database/passwordoverride/CrowdEncryptedPasswordProvider;", "Lcom/atlassian/performance/tools/infrastructure/api/database/passwordoverride/JiraUserEncryptedPasswordProvider;", "jiraDatabaseSchemaName", "", "passwordPlainText", "passwordEncryptedWithAtlassianSecurityPasswordEncoder", "sqlClient", "Lcom/atlassian/performance/tools/infrastructure/database/SshSqlClient;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/atlassian/performance/tools/infrastructure/database/SshSqlClient;)V", "getEncryptedPassword", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "infrastructure"})
public final class CrowdEncryptedPasswordProvider
implements JiraUserEncryptedPasswordProvider {
    private final String jiraDatabaseSchemaName;
    private final String passwordPlainText;
    private final String passwordEncryptedWithAtlassianSecurityPasswordEncoder;
    private final SshSqlClient sqlClient;

    @Override
    @NotNull
    public String getEncryptedPassword(@NotNull SshConnection ssh) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        String sqlResult = this.sqlClient.runSql(ssh, "select attribute_value from " + this.jiraDatabaseSchemaName + ".cwd_directory_attribute where attribute_name = 'user_encryption_method';").getOutput();
        if (StringsKt.contains$default((CharSequence)sqlResult, (CharSequence)"plaintext", (boolean)false, (int)2, null)) {
            string = this.passwordPlainText;
        } else if (StringsKt.contains$default((CharSequence)sqlResult, (CharSequence)"atlassian-security", (boolean)false, (int)2, null)) {
            string = this.passwordEncryptedWithAtlassianSecurityPasswordEncoder;
        } else {
            throw (Throwable)new RuntimeException("Unknown jira user password encryption type");
        }
        return string;
    }

    public CrowdEncryptedPasswordProvider(@NotNull String jiraDatabaseSchemaName, @NotNull String passwordPlainText, @NotNull String passwordEncryptedWithAtlassianSecurityPasswordEncoder, @NotNull SshSqlClient sqlClient) {
        Intrinsics.checkParameterIsNotNull((Object)jiraDatabaseSchemaName, (String)"jiraDatabaseSchemaName");
        Intrinsics.checkParameterIsNotNull((Object)passwordPlainText, (String)"passwordPlainText");
        Intrinsics.checkParameterIsNotNull((Object)passwordEncryptedWithAtlassianSecurityPasswordEncoder, (String)"passwordEncryptedWithAtlassianSecurityPasswordEncoder");
        Intrinsics.checkParameterIsNotNull((Object)sqlClient, (String)"sqlClient");
        this.jiraDatabaseSchemaName = jiraDatabaseSchemaName;
        this.passwordPlainText = passwordPlainText;
        this.passwordEncryptedWithAtlassianSecurityPasswordEncoder = passwordEncryptedWithAtlassianSecurityPasswordEncoder;
        this.sqlClient = sqlClient;
    }
}

