/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.database;

import com.atlassian.performance.tools.infrastructure.api.database.Database;
import com.atlassian.performance.tools.infrastructure.database.Mysql;
import com.atlassian.performance.tools.infrastructure.database.SshSqlClient;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/database/MinimalMysqlDatabase;", "Lcom/atlassian/performance/tools/infrastructure/api/database/Database;", "jiraDbUserPassword", "", "maxConnections", "", "(Ljava/lang/String;I)V", "setup", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "start", "", "jira", "Ljava/net/URI;", "Builder", "infrastructure"})
public final class MinimalMysqlDatabase
implements Database {
    private final String jiraDbUserPassword;
    private final int maxConnections;

    @Override
    @NotNull
    public String setup(@NotNull SshConnection ssh) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        String mysqlDataLocation = "mySqlData";
        ssh.execute("mkdir -p " + mysqlDataLocation);
        Mysql.INSTANCE.container(mysqlDataLocation, new String[]{"-e MYSQL_ALLOW_EMPTY_PASSWORD=yes"}, new String[]{"--max_connections=" + this.maxConnections}).run(ssh);
        return mysqlDataLocation;
    }

    @Override
    public void start(@NotNull URI jira, @NotNull SshConnection ssh) {
        Intrinsics.checkParameterIsNotNull((Object)jira, (String)"jira");
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        SshSqlClient client = Mysql.INSTANCE.installClient(ssh);
        Mysql.INSTANCE.awaitDatabase(ssh);
        client.runSql(ssh, "CREATE USER 'jiradbuser'@'%' IDENTIFIED BY '" + this.jiraDbUserPassword + "';");
        client.runSql(ssh, "CREATE DATABASE jiradb CHARACTER SET utf8mb4 COLLATE utf8mb4_bin;");
        client.runSql(ssh, StringsKt.trimIndent((String)("\n            GRANT SELECT,INSERT,UPDATE,DELETE,CREATE,DROP,REFERENCES,ALTER,INDEX on jiradb.* TO 'jiradbuser'@'%' IDENTIFIED BY '" + this.jiraDbUserPassword + "';\n            flush privileges;\n        ")));
    }

    private MinimalMysqlDatabase(String jiraDbUserPassword, int maxConnections) {
        this.jiraDbUserPassword = jiraDbUserPassword;
        this.maxConnections = maxConnections;
    }

    public /* synthetic */ MinimalMysqlDatabase(@NotNull String jiraDbUserPassword, int maxConnections, DefaultConstructorMarker $constructor_marker) {
        this(jiraDbUserPassword, maxConnections);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/database/MinimalMysqlDatabase$Builder;", "", "()V", "jiraDbUserPassword", "", "maxConnections", "", "build", "Lcom/atlassian/performance/tools/infrastructure/api/database/MinimalMysqlDatabase;", "infrastructure"})
    public static final class Builder {
        private String jiraDbUserPassword = "password";
        private int maxConnections = 151;

        @NotNull
        public final Builder jiraDbUserPassword(@NotNull String jiraDbUserPassword) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jiraDbUserPassword, (String)"jiraDbUserPassword");
            Builder $receiver = builder = this;
            $receiver.jiraDbUserPassword = jiraDbUserPassword;
            return builder;
        }

        @NotNull
        public final Builder maxConnections(int maxConnections) {
            Builder builder;
            Builder $receiver = builder = this;
            $receiver.maxConnections = maxConnections;
            return builder;
        }

        @NotNull
        public final MinimalMysqlDatabase build() {
            return new MinimalMysqlDatabase(this.jiraDbUserPassword, this.maxConnections, null);
        }
    }
}

