/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.browser;

import com.atlassian.performance.tools.infrastructure.api.browser.Browser;
import com.atlassian.performance.tools.infrastructure.api.browser.chromium.Chromium69;
import com.atlassian.performance.tools.infrastructure.api.browser.chromium.Chromium70;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Use version specific Chromium. For example `Chromium69`.")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/browser/Chromium;", "Lcom/atlassian/performance/tools/infrastructure/api/browser/Browser;", "version", "", "(Ljava/lang/String;)V", "install", "", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "Companion", "infrastructure"})
public final class Chromium
implements Browser {
    private final String version;
    private static final Map<String, URI> versionToUri;
    public static final Companion Companion;

    @Override
    public void install(@NotNull SshConnection ssh) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        switch (this.version) {
            case "69": {
                new Chromium69().install(ssh);
                break;
            }
            case "70": {
                new Chromium70().install(ssh);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Chromium version '" + this.version + "' is not supported.");
            }
        }
    }

    public Chromium(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        this.version = version;
        if (!versionToUri.keySet().contains(this.version)) {
            throw (Throwable)new IllegalArgumentException("Chromium version '" + this.version + "' is not supported.");
        }
    }

    static {
        Companion = new Companion(null);
        versionToUri = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"69", (Object)new URI("https://www.googleapis.com/download/storage/v1/b/chromium-browser-snapshots/o/Linux_x64%2F576753%2Fchrome-linux.zip?generation=1532051976706023&alt=media")), TuplesKt.to((Object)"70", (Object)new URI("https://www.googleapis.com/download/storage/v1/b/chromium-browser-snapshots/o/Linux_x64%2F587811%2Fchrome-linux.zip?generation=1535668921668411&alt=media"))});
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/browser/Chromium$Companion;", "", "()V", "versionToUri", "", "", "Ljava/net/URI;", "getSupportedVersions", "", "infrastructure"})
    public static final class Companion {
        private final Set<String> getSupportedVersions() {
            return versionToUri.keySet();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

