/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.browser;

import com.atlassian.performance.tools.infrastructure.ChromeForTesting;
import com.atlassian.performance.tools.infrastructure.ChromedriverInstaller;
import com.atlassian.performance.tools.infrastructure.api.browser.Browser;
import com.atlassian.performance.tools.infrastructure.api.os.Ubuntu;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/browser/Chrome;", "Lcom/atlassian/performance/tools/infrastructure/api/browser/Browser;", "()V", "ubuntu", "Lcom/atlassian/performance/tools/infrastructure/api/os/Ubuntu;", "getInstalledBuildVersion", "", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "install", "", "infrastructure"})
public final class Chrome
implements Browser {
    private final Ubuntu ubuntu = new Ubuntu();

    @Override
    public void install(@NotNull SshConnection ssh) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        this.ubuntu.addRemoteKey(ssh, "https://dl-ssl.google.com/linux/linux_signing_key.pub");
        this.ubuntu.addRepository(ssh, "deb [arch=amd64] http://dl.google.com/linux/chrome/deb/ stable main", "google-chrome");
        Ubuntu ubuntu = new Ubuntu();
        List list = CollectionsKt.listOf((Object)"google-chrome-stable");
        Duration duration = Duration.ofMinutes(5L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ofMinutes(5)");
        ubuntu.install(ssh, list, duration);
        String installedMinorVersion = this.getInstalledBuildVersion(ssh);
        URI uri = installedMinorVersion != null ? ChromeForTesting.INSTANCE.getLatestDownloadUri(installedMinorVersion) : ChromeForTesting.INSTANCE.getLatestStableDownloadUri();
        new ChromedriverInstaller(uri).install$infrastructure(ssh);
    }

    private final String getInstalledBuildVersion(SshConnection ssh) {
        String versionString = ssh.execute("/usr/bin/google-chrome --version").getOutput();
        Object object = Regex.find$default((Regex)new Regex("Google Chrome ([0-9]+\\.[0-9]+\\.[0-9]+)\\.[0-9]+"), (CharSequence)versionString, (int)0, (int)2, null);
        return object != null && (object = object.getGroupValues()) != null ? (String)CollectionsKt.getOrNull((List)object, (int)1) : null;
    }
}

