/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.app;

import com.atlassian.performance.tools.infrastructure.ObrApp;
import com.atlassian.performance.tools.infrastructure.api.app.AppSource;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.HeaderValueParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\f\u0010\u000f\u001a\u00020\u0003*\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/app/MarketplaceApp;", "Lcom/atlassian/performance/tools/infrastructure/api/app/AppSource;", "key", "", "(Ljava/lang/String;)V", "build", "(Ljava/lang/String;Ljava/lang/String;)V", "acquireFiles", "", "Ljava/io/File;", "directory", "downloadToDirectory", "url", "Ljava/net/URL;", "getLabel", "attachmentFilename", "Ljava/net/URLConnection;", "infrastructure"})
public final class MarketplaceApp
implements AppSource {
    private final String key;
    private final String build;

    @Override
    @NotNull
    public String getLabel() {
        return this.key + ':' + this.build;
    }

    @Override
    @NotNull
    public List<File> acquireFiles(@NotNull File directory) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        URL url = Intrinsics.areEqual((Object)this.build, (Object)"latest") ? new URL("https://marketplace.atlassian.com/download/plugins/" + this.key) : new URL("https://marketplace.atlassian.com/download/plugins/" + this.key + "/version/" + this.build);
        File file = this.downloadToDirectory(url, directory);
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"obr") ? new ObrApp(file).extractJars(directory) : CollectionsKt.listOf((Object)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File downloadToDirectory(URL url, File directory) {
        URLConnection connection = url.openConnection();
        connection.connect();
        URLConnection uRLConnection = connection;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRLConnection, (String)"connection");
        File file = FilesKt.resolve((File)directory, (String)this.attachmentFilename(uRLConnection));
        Closeable closeable = url.openStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            long l = Files.copy(it, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return file;
    }

    private final String attachmentFilename(@NotNull URLConnection $receiver) {
        String string = $receiver.getHeaderField("Content-Disposition");
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String contentDisposition = string;
        NameValuePair nameValuePair = BasicHeaderValueParser.parseHeaderElement((String)contentDisposition, (HeaderValueParser)((HeaderValueParser)BasicHeaderValueParser.INSTANCE)).getParameterByName("filename");
        Intrinsics.checkExpressionValueIsNotNull((Object)nameValuePair, (String)"parseHeaderElement(conte\u2026rameterByName(\"filename\")");
        String string2 = nameValuePair.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"parseHeaderElement(conte\u2026name\")\n            .value");
        return string2;
    }

    public MarketplaceApp(@NotNull String key, @NotNull String build) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)build, (String)"build");
        this.key = key;
        this.build = build;
    }

    public MarketplaceApp(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this(key, "latest");
    }
}

