/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure;

import com.atlassian.performance.tools.infrastructure.HttpResource;
import com.atlassian.performance.tools.infrastructure.api.distribution.ProductDistribution;
import com.atlassian.performance.tools.infrastructure.api.distribution.TarGzDistribution;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.net.URI;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/performance/tools/infrastructure/PublicAtlassianProduct;", "Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "archiveName", "", "(Ljava/lang/String;)V", "install", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "destination", "infrastructure"})
public final class PublicAtlassianProduct
implements ProductDistribution {
    private final String archiveName;

    @Override
    @NotNull
    public String install(@NotNull SshConnection ssh, @NotNull String destination) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        URI jiraArchiveUri = new URI("https://product-downloads.atlassian.com/software/jira/downloads/" + this.archiveName);
        ssh.execute("mkdir --parents " + destination);
        String archive = destination + '/' + this.archiveName;
        HttpResource httpResource = new HttpResource(jiraArchiveUri);
        Duration duration = Duration.ofMinutes(6L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(6)");
        httpResource.download(ssh, archive, duration);
        return new TarGzDistribution(archive).install(ssh, destination);
    }

    public PublicAtlassianProduct(@NotNull String archiveName) {
        Intrinsics.checkParameterIsNotNull((Object)archiveName, (String)"archiveName");
        this.archiveName = archiveName;
    }
}

