/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure;

import com.atlassian.performance.tools.infrastructure.api.os.Ubuntu;
import com.atlassian.performance.tools.jvmtasks.api.Backoff;
import com.atlassian.performance.tools.jvmtasks.api.IdempotentAction;
import com.atlassian.performance.tools.jvmtasks.api.StaticBackoff;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/performance/tools/infrastructure/Docker;", "", "()V", "ubuntu", "Lcom/atlassian/performance/tools/infrastructure/api/os/Ubuntu;", "addDockerOfficialGpgKey", "", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "allowAptToUseHttps", "dockerUlimitWorkaround", "install", "installDockerEngine", "setUpTheRepository", "startDockerIfNecessary", "infrastructure"})
public final class Docker {
    private final Ubuntu ubuntu = new Ubuntu();

    public final void install(@NotNull SshConnection ssh) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        this.allowAptToUseHttps(ssh);
        this.addDockerOfficialGpgKey(ssh);
        this.setUpTheRepository(ssh);
        this.installDockerEngine(ssh);
        this.startDockerIfNecessary(ssh);
    }

    private final void allowAptToUseHttps(SshConnection ssh) {
        Set set;
        String string = this.ubuntu.getDistributionCodename(ssh);
        switch (string.hashCode()) {
            case -762812525: {
                if (string.equals("xenial")) {
                    set = SetsKt.setOf((Object)"apt-transport-https");
                    break;
                }
            }
            default: {
                set = SetsKt.emptySet();
            }
        }
        Set extraPackages = set;
        List list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new String[]{"ca-certificates", "curl", "gnupg", "lsb-release"}), (Iterable)extraPackages);
        Duration duration = Duration.ofMinutes(2L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(2)");
        this.ubuntu.install(ssh, list, duration);
    }

    private final void addDockerOfficialGpgKey(SshConnection ssh) {
        ssh.execute("sudo mkdir -p /etc/apt/keyrings");
        String gpgFix = "--batch";
        String gpg = "sudo gpg " + gpgFix + " --dearmor -o /etc/apt/keyrings/docker.gpg";
        String addGpg = "curl -fsSL https://download.docker.com/linux/ubuntu/gpg | " + gpg;
        if (!ssh.safeExecute(addGpg).isSuccessful()) {
            ssh.execute("sudo chmod a+r /etc/apt/keyrings/docker.gpg");
            ssh.safeExecute(addGpg);
        }
    }

    private final void setUpTheRepository(SshConnection ssh) {
        String arch = "arch=$(dpkg --print-architecture)";
        String signed = "signed-by=/etc/apt/keyrings/docker.gpg";
        String release = "$(lsb_release -cs) stable";
        String source = "deb [" + arch + ' ' + signed + "] https://download.docker.com/linux/ubuntu " + release;
        ssh.execute("echo \"" + source + "\" | sudo tee /etc/apt/sources.list.d/docker.list > /dev/null");
    }

    private final void installDockerEngine(SshConnection ssh) {
        Set set;
        String string = this.ubuntu.getDistributionCodename(ssh);
        switch (string.hashCode()) {
            case -762812525: {
                if (string.equals("xenial")) {
                    set = SetsKt.setOf((Object)"docker-compose-plugin");
                    break;
                }
            }
            default: {
                set = SetsKt.emptySet();
            }
        }
        Set missingPackages = set;
        List list = CollectionsKt.minus((Iterable)CollectionsKt.listOf((Object[])new String[]{"docker-ce", "docker-ce-cli", "containerd.io"}), (Iterable)missingPackages);
        Duration duration = Duration.ofMinutes(5L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(5)");
        this.ubuntu.install(ssh, list, duration);
    }

    private final void startDockerIfNecessary(SshConnection ssh) {
        this.dockerUlimitWorkaround(ssh);
        ssh.execute("sudo service docker status || sudo service docker start");
        IdempotentAction idempotentAction = new IdempotentAction("Check if Docker is running", (Function0)new Function0<SshConnection.SshResult>(ssh){
            final /* synthetic */ SshConnection $ssh;

            @NotNull
            public final SshConnection.SshResult invoke() {
                Duration duration = Duration.ofSeconds(10L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(10)");
                Level level = Level.DEBUG;
                Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.DEBUG");
                Level level2 = Level.DEBUG;
                Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.DEBUG");
                return this.$ssh.execute("sudo docker ps", duration, level, level2);
            }
            {
                this.$ssh = sshConnection;
                super(0);
            }
        });
        Duration duration = Duration.ofMillis(500L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMillis(500)");
        idempotentAction.retry(10, (Backoff)new StaticBackoff(duration));
    }

    private final void dockerUlimitWorkaround(SshConnection ssh) {
        ssh.execute("sudo sed -i 's/ulimit -Hn/ulimit -n/' /etc/init.d/docker");
    }
}

