/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.concurrency.api;

import com.atlassian.performance.tools.concurrency.api.GracefulTerminationKt;
import com.atlassian.performance.tools.concurrency.api.TraceableTask;
import java.time.Instant;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/performance/tools/concurrency/api/TraceableFuture;", "T", "", "task", "Lcom/atlassian/performance/tools/concurrency/api/TraceableTask;", "future", "Ljava/util/concurrent/Future;", "(Lcom/atlassian/performance/tools/concurrency/api/TraceableTask;Ljava/util/concurrent/Future;)V", "finishBy", "deadline", "Ljava/time/Instant;", "logger", "Lorg/apache/logging/log4j/Logger;", "(Ljava/time/Instant;Lorg/apache/logging/log4j/Logger;)Ljava/lang/Object;", "concurrency"})
public final class TraceableFuture<T> {
    private final TraceableTask<T> task;
    private final Future<T> future;

    public final T finishBy(@NotNull Instant deadline, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)deadline, (String)"deadline");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        try {
            return GracefulTerminationKt.finishBy(this.future, deadline, logger);
        }
        catch (Exception e) {
            e.addSuppressed(this.task.trace());
            throw (Throwable)new Exception(this.future + " failed to finish by " + deadline, e);
        }
    }

    public TraceableFuture(@NotNull TraceableTask<T> task, @NotNull Future<T> future) {
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        Intrinsics.checkParameterIsNotNull(future, (String)"future");
        this.task = task;
        this.future = future;
    }
}

