/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api.ami;

import com.atlassian.performance.tools.aws.ami.UnattendedUpgradesOptOut;
import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.CanonicalImageIdByNameResolver;
import com.atlassian.performance.tools.aws.api.ami.AmiProvider;
import com.atlassian.performance.tools.aws.api.ami.SshAmiMod;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/performance/tools/aws/api/ami/CanonicalAmiProvider;", "Lcom/atlassian/performance/tools/aws/api/ami/AmiProvider;", "imageName", "", "avoidUnattendedUpgrades", "", "(Ljava/lang/String;Z)V", "provideAmiId", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "Builder", "ImageNameResolver", "aws-resources"})
public final class CanonicalAmiProvider
implements AmiProvider {
    private final String imageName;
    private final boolean avoidUnattendedUpgrades;

    @Override
    @NotNull
    public String provideAmiId(@NotNull Aws aws) {
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        ImageNameResolver base = new ImageNameResolver();
        AmiProvider provider = this.avoidUnattendedUpgrades ? (AmiProvider)new SshAmiMod.Builder(new UnattendedUpgradesOptOut()).amiProvider(base).build() : (AmiProvider)base;
        return provider.provideAmiId(aws);
    }

    private CanonicalAmiProvider(String imageName, boolean avoidUnattendedUpgrades) {
        this.imageName = imageName;
        this.avoidUnattendedUpgrades = avoidUnattendedUpgrades;
    }

    public /* synthetic */ CanonicalAmiProvider(String imageName, boolean avoidUnattendedUpgrades, DefaultConstructorMarker $constructor_marker) {
        this(imageName, avoidUnattendedUpgrades);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/performance/tools/aws/api/ami/CanonicalAmiProvider$ImageNameResolver;", "Lcom/atlassian/performance/tools/aws/api/ami/AmiProvider;", "(Lcom/atlassian/performance/tools/aws/api/ami/CanonicalAmiProvider;)V", "provideAmiId", "", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "aws-resources"})
    private final class ImageNameResolver
    implements AmiProvider {
        @Override
        @NotNull
        public String provideAmiId(@NotNull Aws aws) {
            Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
            return new CanonicalImageIdByNameResolver.Builder(aws.getEc2()).region(aws.getRegion()).build().invoke(CanonicalAmiProvider.this.imageName);
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0000J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u0005\u001a\u00020\u0000J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/performance/tools/aws/api/ami/CanonicalAmiProvider$Builder;", "", "()V", "avoidUnattendedUpgrades", "", "focal", "", "imageName", "build", "Lcom/atlassian/performance/tools/aws/api/ami/CanonicalAmiProvider;", "aws-resources"})
    public static final class Builder {
        private final String focal = "ubuntu/images/hvm-ssd/ubuntu-focal-20.04-amd64-server-20250603";
        private String imageName;
        private boolean avoidUnattendedUpgrades;

        @NotNull
        public final Builder imageName(@NotNull String imageName) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)imageName, (String)"imageName");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.avoidUnattendedUpgrades = false;
            $receiver.imageName = imageName;
            return builder;
        }

        @NotNull
        public final Builder avoidUnattendedUpgrades() {
            Builder builder;
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.avoidUnattendedUpgrades = true;
            return builder;
        }

        @NotNull
        public final Builder focal() {
            return this.imageName(this.focal).avoidUnattendedUpgrades();
        }

        @NotNull
        public final CanonicalAmiProvider build() {
            return new CanonicalAmiProvider(this.imageName, this.avoidUnattendedUpgrades, null);
        }

        public Builder() {
            this.imageName = this.focal = "ubuntu/images/hvm-ssd/ubuntu-focal-20.04-amd64-server-20250603";
            this.avoidUnattendedUpgrades = true;
        }
    }
}

