/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api;

import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.services.cloudformation.model.ListStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.ListStackResourcesResult;
import com.amazonaws.services.cloudformation.model.ResourceStatus;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.StackResourceSummary;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.DescribeSubnetsRequest;
import com.amazonaws.services.ec2.model.DescribeSubnetsResult;
import com.amazonaws.services.ec2.model.DescribeVpcsRequest;
import com.amazonaws.services.ec2.model.DescribeVpcsResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.Subnet;
import com.amazonaws.services.ec2.model.Vpc;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersResult;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerDescription;
import com.amazonaws.services.identitymanagement.model.AttachedPolicy;
import com.amazonaws.services.identitymanagement.model.DeleteRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.DetachRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.ListAttachedRolePoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListAttachedRolePoliciesResult;
import com.amazonaws.services.identitymanagement.model.ListRolePoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListRolePoliciesResult;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.Resource;
import com.atlassian.performance.tools.aws.api.Storage;
import com.atlassian.performance.tools.aws.api.Tag;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bH\u0002J\b\u0010!\u001a\u00020\u001fH\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\bH\u0002J\b\u0010$\u001a\u00020\u001fH\u0002J\u0018\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0002J\u001e\u0010'\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0\u001bH\u0002J\u0018\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u001b2\u0006\u0010-\u001a\u00020\bH\u0002J\u000e\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\bJ\u0006\u00100\u001a\u000201J\u0018\u00102\u001a\u00020\b2\u0006\u0010-\u001a\u00020\b2\u0006\u0010/\u001a\u00020\bH\u0002J\u000e\u00103\u001a\u0002042\u0006\u0010/\u001a\u00020\bJ\u0016\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\bJ\u000e\u00109\u001a\u00020:2\u0006\u0010/\u001a\u00020\bJ\u000e\u0010;\u001a\u00020<2\u0006\u0010/\u001a\u00020\bJ\b\u0010=\u001a\u00020>H\u0016J\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@0\u001bJ\f\u0010A\u001a\u0006\u0012\u0002\b\u00030BH\u0016J\b\u0010C\u001a\u00020\bH\u0016J\f\u0010D\u001a\u00020>*\u00020,H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR2\u0010\u0017\u001a&\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019 \u001a*\u0012\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019\u0018\u00010\u001b0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\n\u00a8\u0006E"}, d2={"Lcom/atlassian/performance/tools/aws/api/ProvisionedStack;", "Lcom/atlassian/performance/tools/aws/api/Resource;", "stack", "Lcom/amazonaws/services/cloudformation/model/Stack;", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "(Lcom/amazonaws/services/cloudformation/model/Stack;Lcom/atlassian/performance/tools/aws/api/Aws;)V", "bambooBuild", "", "getBambooBuild", "()Ljava/lang/String;", "expiry", "Ljava/time/Instant;", "getExpiry", "()Ljava/time/Instant;", "lifespan", "Ljava/time/Duration;", "logger", "Lorg/apache/logging/log4j/Logger;", "stackName", "getStackName", "status", "getStatus", "tags", "", "Lcom/amazonaws/services/cloudformation/model/Tag;", "kotlin.jvm.PlatformType", "", "user", "getUser", "cleanBucket", "", "bucketName", "cleanBuckets", "cleanRole", "roleName", "cleanRoles", "deleteInlinePolicy", "policyName", "deleteObjects", "objectKeys", "detachAttachedPolicy", "policyArn", "filterResources", "Lcom/amazonaws/services/cloudformation/model/StackResourceSummary;", "resourceType", "findInstanceProfile", "logicalId", "findLoadBalancer", "Lcom/amazonaws/services/elasticloadbalancing/model/LoadBalancerDescription;", "findLogicalResource", "findSecurityGroup", "Lcom/amazonaws/services/ec2/model/SecurityGroup;", "findStorage", "Lcom/atlassian/performance/tools/aws/api/Storage;", "logicalBucketName", "prefix", "findSubnet", "Lcom/amazonaws/services/ec2/model/Subnet;", "findVpc", "Lcom/amazonaws/services/ec2/model/Vpc;", "isExpired", "", "listMachines", "Lcom/amazonaws/services/ec2/model/Instance;", "release", "Ljava/util/concurrent/CompletableFuture;", "toString", "isAlive", "aws-resources"})
public final class ProvisionedStack
implements Resource {
    private final Logger logger;
    @NotNull
    private final String stackName;
    @NotNull
    private final String status;
    private final List<com.amazonaws.services.cloudformation.model.Tag> tags;
    private final Duration lifespan;
    @NotNull
    private final Instant expiry;
    @Nullable
    private final String user;
    @Nullable
    private final String bambooBuild;
    private final Aws aws;

    @NotNull
    public final String getStackName() {
        return this.stackName;
    }

    @NotNull
    public final String getStatus() {
        return this.status;
    }

    @NotNull
    public final Instant getExpiry() {
        return this.expiry;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    @Nullable
    public final String getBambooBuild() {
        return this.bambooBuild;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Instance> listMachines() {
        void var3_5;
        Reservation it;
        Collection<String> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = this.filterResources("AWS::EC2::Instance");
        DescribeInstancesRequest describeInstancesRequest = new DescribeInstancesRequest();
        AmazonEC2 amazonEC2 = this.aws.getEc2();
        void var2_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            StackResourceSummary stackResourceSummary = (StackResourceSummary)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getPhysicalResourceId();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        DescribeInstancesResult describeInstancesResult = amazonEC2.describeInstances(describeInstancesRequest.withInstanceIds((Collection)collection));
        Intrinsics.checkExpressionValueIsNotNull((Object)describeInstancesResult, (String)"aws\n            .ec2\n   \u2026sourceId }\n            ))");
        List list = describeInstancesResult.getReservations();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"aws\n            .ec2\n   \u2026            .reservations");
        $receiver$iv = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Reservation)element$iv$iv;
            boolean bl = false;
            Reservation reservation = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)reservation, (String)"it");
            Iterable list$iv$iv = reservation.getInstances();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)var3_5;
    }

    @NotNull
    public final Storage findStorage(@NotNull String logicalBucketName, @NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)logicalBucketName, (String)"logicalBucketName");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        return new Storage(this.aws.getS3(), prefix, this.findLogicalResource("AWS::S3::Bucket", logicalBucketName));
    }

    private final List<StackResourceSummary> filterResources(String resourceType) {
        StackResourceSummary it;
        Iterable $receiver$iv$iv;
        ListStackResourcesResult listStackResourcesResult = this.aws.getCloudformation().listStackResources(new ListStackResourcesRequest().withStackName(this.stackName));
        Intrinsics.checkExpressionValueIsNotNull((Object)listStackResourcesResult, (String)"aws\n            .cloudfo\u2026(stackName)\n            )");
        List list = listStackResourcesResult.getStackResourceSummaries();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"aws\n            .cloudfo\u2026  .stackResourceSummaries");
        Iterable $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (StackResourceSummary)element$iv$iv;
            boolean bl = false;
            StackResourceSummary stackResourceSummary = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)stackResourceSummary, (String)"it");
            if (!Intrinsics.areEqual((Object)stackResourceSummary.getResourceType(), (Object)resourceType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (StackResourceSummary)element$iv$iv;
            boolean bl = false;
            StackResourceSummary stackResourceSummary = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)stackResourceSummary, (String)"it");
            if (!this.isAlive(stackResourceSummary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isAlive(StackResourceSummary $receiver) {
        return !CollectionsKt.listOf((Object[])new ResourceStatus[]{ResourceStatus.DELETE_IN_PROGRESS, ResourceStatus.DELETE_COMPLETE}).contains(ResourceStatus.fromValue((String)$receiver.getResourceStatus()));
    }

    private final String findLogicalResource(String resourceType, String logicalId) {
        String resource;
        Object v0;
        block2: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)this.filterResources(resourceType);
            for (Object t : iterable2) {
                StackResourceSummary it = (StackResourceSummary)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getLogicalResourceId(), (Object)logicalId)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        StackResourceSummary stackResourceSummary = v0;
        String string = resource = stackResourceSummary != null ? stackResourceSummary.getPhysicalResourceId() : null;
        if (string == null) {
            throw (Throwable)new RuntimeException(this.stackName + " does not have " + resourceType + " with '" + logicalId + "' logical id");
        }
        return string;
    }

    @NotNull
    public final String findInstanceProfile(@NotNull String logicalId) {
        Intrinsics.checkParameterIsNotNull((Object)logicalId, (String)"logicalId");
        return this.findLogicalResource("AWS::IAM::InstanceProfile", logicalId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LoadBalancerDescription findLoadBalancer() {
        void var3_3;
        String loadBalancerName = ((StackResourceSummary)CollectionsKt.single(this.filterResources("AWS::ElasticLoadBalancing::LoadBalancer"))).getPhysicalResourceId();
        DescribeLoadBalancersResult describeLoadBalancersResult = this.aws.getLoadBalancer().describeLoadBalancers();
        Intrinsics.checkExpressionValueIsNotNull((Object)describeLoadBalancersResult, (String)"aws\n            .loadBal\u2026 .describeLoadBalancers()");
        List list = describeLoadBalancersResult.getLoadBalancerDescriptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"aws\n            .loadBal\u2026.loadBalancerDescriptions");
        Iterable $receiver$iv = list;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $receiver$iv) {
            LoadBalancerDescription it = (LoadBalancerDescription)element$iv;
            boolean bl = false;
            LoadBalancerDescription loadBalancerDescription = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)loadBalancerDescription, (String)"it");
            if (!Intrinsics.areEqual((Object)loadBalancerDescription.getLoadBalancerName(), (Object)loadBalancerName)) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        void v3 = var3_3;
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"aws\n            .loadBal\u2026ame == loadBalancerName }");
        return (LoadBalancerDescription)v3;
    }

    @NotNull
    public final Subnet findSubnet(@NotNull String logicalId) {
        Intrinsics.checkParameterIsNotNull((Object)logicalId, (String)"logicalId");
        DescribeSubnetsResult describeSubnetsResult = this.aws.getEc2().describeSubnets(new DescribeSubnetsRequest().withSubnetIds(new String[]{this.findLogicalResource("AWS::EC2::Subnet", logicalId)}));
        Intrinsics.checkExpressionValueIsNotNull((Object)describeSubnetsResult, (String)"aws\n        .ec2\n       \u2026)\n            )\n        )");
        List list = describeSubnetsResult.getSubnets();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"aws\n        .ec2\n       \u2026       )\n        .subnets");
        Object object = CollectionsKt.single((List)list);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"aws\n        .ec2\n       \u2026subnets\n        .single()");
        return (Subnet)object;
    }

    @NotNull
    public final Vpc findVpc(@NotNull String logicalId) {
        Intrinsics.checkParameterIsNotNull((Object)logicalId, (String)"logicalId");
        DescribeVpcsResult describeVpcsResult = this.aws.getEc2().describeVpcs(new DescribeVpcsRequest().withVpcIds(new String[]{this.findLogicalResource("AWS::EC2::VPC", logicalId)}));
        Intrinsics.checkExpressionValueIsNotNull((Object)describeVpcsResult, (String)"aws\n        .ec2\n       \u2026)\n            )\n        )");
        List list = describeVpcsResult.getVpcs();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"aws\n        .ec2\n       \u2026)\n        )\n        .vpcs");
        Object object = CollectionsKt.single((List)list);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"aws\n        .ec2\n       \u2026  .vpcs\n        .single()");
        return (Vpc)object;
    }

    @NotNull
    public final SecurityGroup findSecurityGroup(@NotNull String logicalId) {
        Intrinsics.checkParameterIsNotNull((Object)logicalId, (String)"logicalId");
        DescribeSecurityGroupsResult describeSecurityGroupsResult = this.aws.getEc2().describeSecurityGroups(new DescribeSecurityGroupsRequest().withGroupIds(new String[]{this.findLogicalResource("AWS::EC2::SecurityGroup", logicalId)}));
        Intrinsics.checkExpressionValueIsNotNull((Object)describeSecurityGroupsResult, (String)"aws\n        .ec2\n       \u2026)\n            )\n        )");
        List list = describeSecurityGroupsResult.getSecurityGroups();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"aws\n        .ec2\n       \u2026)\n        .securityGroups");
        Object object = CollectionsKt.single((List)list);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"aws\n        .ec2\n       \u2026yGroups\n        .single()");
        return (SecurityGroup)object;
    }

    @Override
    public boolean isExpired() {
        return this.expiry.compareTo(Instant.now()) < 0;
    }

    @Override
    @NotNull
    public CompletableFuture<?> release() {
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(new Runnable(this){
            final /* synthetic */ ProvisionedStack this$0;

            public final void run() {
                ProvisionedStack.access$cleanBuckets(this.this$0);
                ProvisionedStack.access$cleanRoles(this.this$0);
                ProvisionedStack.access$getLogger$p(this.this$0).debug("Deleting stack " + this.this$0.getStackName());
                ProvisionedStack.access$getAws$p(this.this$0).getCloudformation().deleteStack(new DeleteStackRequest().withStackName(this.this$0.getStackName()));
            }
            {
                this.this$0 = provisionedStack;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.runAsy\u2026ame(stackName))\n        }");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanBuckets() {
        void $receiver$iv$iv;
        this.logger.debug("Cleaning buckets in " + this.stackName);
        Iterable $receiver$iv = this.filterResources("AWS::S3::Bucket");
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            StackResourceSummary stackResourceSummary = (StackResourceSummary)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getPhysicalResourceId();
            collection.add(string);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            this.cleanBucket(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanBucket(String bucketName) {
        List objectKeys;
        Collection collection;
        this.logger.debug("Cleaning bucket " + bucketName);
        do {
            void $receiver$iv$iv;
            ObjectListing objectListing = this.aws.getS3().listObjects(bucketName);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectListing, (String)"aws\n                .s3\n\u2026 .listObjects(bucketName)");
            List list = objectListing.getObjectSummaries();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"aws\n                .s3\n\u2026         .objectSummaries");
            Iterable $receiver$iv = list;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                S3ObjectSummary s3ObjectSummary = (S3ObjectSummary)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                void v2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                String string = v2.getKey();
                collection2.add(string);
            }
            objectKeys = (List)destination$iv$iv;
            this.deleteObjects(bucketName, objectKeys);
        } while (!(collection = (Collection)objectKeys).isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteObjects(String bucketName, List<String> objectKeys) {
        if (objectKeys.isEmpty()) {
            return;
        }
        try {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            this.logger.debug("Deleting " + objectKeys.size() + " objects from " + bucketName);
            Iterable iterable = $receiver$iv = (Iterable)objectKeys;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                DeleteObjectsRequest.KeyVersion keyVersion = new DeleteObjectsRequest.KeyVersion((String)it);
                collection.add(keyVersion);
            }
            List versionedKeys = (List)destination$iv$iv;
            this.aws.getS3().deleteObjects(new DeleteObjectsRequest(bucketName).withKeys(versionedKeys).withQuiet(true));
        }
        catch (MultiObjectDeleteException e) {
            Iterable $receiver$iv;
            List list = e.getErrors();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"e.errors");
            Iterable $receiver$iv$iv = $receiver$iv = (Iterable)list;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                MultiObjectDeleteException.DeleteError it = (MultiObjectDeleteException.DeleteError)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                MultiObjectDeleteException.DeleteError deleteError = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)deleteError, (String)"it");
                String string = deleteError.getKey();
                collection.add(string);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (this.aws.getS3().doesObjectExist(bucketName, it)) {
                    throw (Throwable)new RuntimeException("Failed to delete " + it + " from " + bucketName, e);
                }
                this.logger.debug("Lost a race to delete " + it + " from " + bucketName);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanRoles() {
        void $receiver$iv$iv;
        this.logger.debug("Cleaning roles in " + this.stackName);
        Iterable $receiver$iv = this.filterResources("AWS::IAM::Role");
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            StackResourceSummary stackResourceSummary = (StackResourceSummary)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getPhysicalResourceId();
            collection.add(string);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            this.cleanRole(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanRole(String roleName) {
        String it;
        void $receiver$iv$iv;
        ListAttachedRolePoliciesResult listAttachedRolePoliciesResult = this.aws.getIam().listAttachedRolePolicies(new ListAttachedRolePoliciesRequest().withRoleName(roleName));
        Intrinsics.checkExpressionValueIsNotNull((Object)listAttachedRolePoliciesResult, (String)"aws\n            .iam\n   \u2026e(roleName)\n            )");
        List list = listAttachedRolePoliciesResult.getAttachedPolicies();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"aws\n            .iam\n   \u2026        .attachedPolicies");
        Iterable $receiver$iv = list;
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            AttachedPolicy attachedPolicy = (AttachedPolicy)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            String string = v2.getPolicyArn();
            collection.add(string);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (String)element$iv;
            boolean bl = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            this.detachAttachedPolicy(string, roleName);
        }
        ListRolePoliciesResult listRolePoliciesResult = this.aws.getIam().listRolePolicies(new ListRolePoliciesRequest().withRoleName(roleName));
        Intrinsics.checkExpressionValueIsNotNull((Object)listRolePoliciesResult, (String)"aws\n            .iam\n   \u2026e(roleName)\n            )");
        List list2 = listRolePoliciesResult.getPolicyNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"aws\n            .iam\n   \u2026\n            .policyNames");
        $receiver$iv = list2;
        for (Object element$iv : $receiver$iv) {
            it = (String)element$iv;
            boolean bl = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            this.deleteInlinePolicy(string, roleName);
        }
    }

    private final void detachAttachedPolicy(String policyArn, String roleName) {
        this.aws.getIam().detachRolePolicy(new DetachRolePolicyRequest().withRoleName(roleName).withPolicyArn(policyArn));
    }

    private final void deleteInlinePolicy(String policyName, String roleName) {
        this.aws.getIam().deleteRolePolicy(new DeleteRolePolicyRequest().withPolicyName(policyName).withRoleName(roleName));
    }

    @NotNull
    public String toString() {
        return "ProvisionedStack(stackName=" + this.stackName + ", lifespan=" + this.lifespan + ')';
    }

    public ProvisionedStack(@NotNull Stack stack, @NotNull Aws aws) {
        com.amazonaws.services.cloudformation.model.Tag it;
        Object object;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        this.aws = aws;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        String string = stack.getStackName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stack.stackName");
        this.stackName = string;
        String string2 = stack.getStackStatus();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"stack.stackStatus");
        this.status = string2;
        this.tags = stack.getTags();
        List<com.amazonaws.services.cloudformation.model.Tag> list = this.tags;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"tags");
        Iterable iterable = list;
        Object object2 = Investment.TagKeys;
        ProvisionedStack provisionedStack = this;
        void var4_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            com.amazonaws.services.cloudformation.model.Tag tag = (com.amazonaws.services.cloudformation.model.Tag)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            void v4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
            Tag tag2 = new Tag((com.amazonaws.services.cloudformation.model.Tag)v4);
            object.add(tag2);
        }
        object = (List)destination$iv$iv;
        Duration duration = ((Investment.TagKeys)object2).parseLifespan((List<Tag>)object);
        if (duration == null) {
            throw (Throwable)new Exception("The stack '" + stack + "' is not provisioned. It misses lifespan tag.");
        }
        provisionedStack.lifespan = duration;
        Instant instant = stack.getCreationTime().toInstant().plus(this.lifespan);
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"stack.creationTime.toInstant() + lifespan");
        this.expiry = instant;
        List<com.amazonaws.services.cloudformation.model.Tag> list2 = this.tags;
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"tags");
        $receiver$iv = list2;
        provisionedStack = this;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (com.amazonaws.services.cloudformation.model.Tag)element$iv$iv;
            boolean bl = false;
            com.amazonaws.services.cloudformation.model.Tag tag = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"it");
            if (!Intrinsics.areEqual((Object)tag.getKey(), (Object)"os_user_name")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object2 = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)object2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (com.amazonaws.services.cloudformation.model.Tag)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            com.amazonaws.services.cloudformation.model.Tag tag = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"it");
            object = tag.getValue();
            object2.add(object);
        }
        object2 = (List)destination$iv$iv;
        provisionedStack.user = (String)CollectionsKt.firstOrNull((List)object2);
        List<com.amazonaws.services.cloudformation.model.Tag> list3 = this.tags;
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"tags");
        $receiver$iv = list3;
        provisionedStack = this;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (com.amazonaws.services.cloudformation.model.Tag)element$iv$iv;
            boolean bl = false;
            com.amazonaws.services.cloudformation.model.Tag tag = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"it");
            if (!Intrinsics.areEqual((Object)tag.getKey(), (Object)"bamboo_result_key")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object2 = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)object2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (com.amazonaws.services.cloudformation.model.Tag)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            com.amazonaws.services.cloudformation.model.Tag tag = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"it");
            object = tag.getValue();
            object2.add(object);
        }
        object2 = (List)destination$iv$iv;
        provisionedStack.bambooBuild = (String)CollectionsKt.firstOrNull((List)object2);
    }

    public static final /* synthetic */ void access$cleanBuckets(ProvisionedStack $this) {
        $this.cleanBuckets();
    }

    public static final /* synthetic */ void access$cleanRoles(ProvisionedStack $this) {
        $this.cleanRoles();
    }

    public static final /* synthetic */ Logger access$getLogger$p(ProvisionedStack $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Aws access$getAws$p(ProvisionedStack $this) {
        return $this.aws;
    }
}

