/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api;

import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.InvestmentKt;
import com.atlassian.performance.tools.aws.api.Tag;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0002\"#B1\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\nB;\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0011\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c2\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c2\u0003J4\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tJA\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/atlassian/performance/tools/aws/api/Investment;", "", "useCase", "", "lifespan", "Ljava/time/Duration;", "disposable", "", "reuseKey", "Lkotlin/Function0;", "(Ljava/lang/String;Ljava/time/Duration;ZLkotlin/jvm/functions/Function0;)V", "resourceOwner", "(Ljava/lang/String;Ljava/time/Duration;ZLkotlin/jvm/functions/Function0;Ljava/lang/String;)V", "getLifespan", "()Ljava/time/Duration;", "getReuseKey", "()Lkotlin/jvm/functions/Function0;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "tag", "", "Lcom/atlassian/performance/tools/aws/api/Tag;", "tagAtlassianAwsAccountability", "tagInitiator", "tagLifecycle", "toString", "Builder", "TagKeys", "aws-resources"})
public final class Investment {
    private final String useCase;
    @NotNull
    private final Duration lifespan;
    private final boolean disposable;
    @NotNull
    private final Function0<String> reuseKey;
    private final String resourceOwner;
    @NotNull
    public static final String lifespanKey = "lifespan";
    private static final String expiryKey = "expiry";
    @NotNull
    public static final String userKey = "os_user_name";
    @NotNull
    public static final String bambooBuildKey = "bamboo_result_key";
    @NotNull
    public static final String disposableKey = "disposable";
    private static final String defaultResourceOwner = "jforemski";
    @NotNull
    public static final TagKeys TagKeys = new TagKeys(null);

    @NotNull
    public final List<Tag> tag() {
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.tagAtlassianAwsAccountability(), (Iterable)this.tagLifecycle()), (Iterable)this.tagInitiator());
    }

    @NotNull
    public final Investment copy(@NotNull String useCase, @NotNull Duration lifespan, boolean disposable, @NotNull Function0<String> reuseKey2) {
        Intrinsics.checkParameterIsNotNull((Object)useCase, (String)"useCase");
        Intrinsics.checkParameterIsNotNull((Object)lifespan, (String)lifespanKey);
        Intrinsics.checkParameterIsNotNull(reuseKey2, (String)"reuseKey");
        return new Investment(useCase, lifespan, disposable, reuseKey2);
    }

    public static /* synthetic */ Investment copy$default(Investment investment, String string, Duration duration, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            string = investment.useCase;
        }
        if ((n & 2) != 0) {
            duration = investment.lifespan;
        }
        if ((n & 4) != 0) {
            bl = investment.disposable;
        }
        if ((n & 8) != 0) {
            function0 = investment.reuseKey;
        }
        return investment.copy(string, duration, bl, function0);
    }

    private final List<Tag> tagAtlassianAwsAccountability() {
        return CollectionsKt.listOf((Object[])new Tag[]{new Tag("Name", "Jira Performance Tests"), new Tag("service_name", this.useCase), new Tag("business_unit", "Engineering-Server"), new Tag("resource_owner", this.resourceOwner)});
    }

    private final List<Tag> tagLifecycle() {
        Object[] objectArray = new Tag[3];
        objectArray[0] = this.disposable ? new Tag(disposableKey, "true") : null;
        String string = this.lifespan.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lifespan.toString()");
        objectArray[1] = new Tag(lifespanKey, string);
        String string2 = Instant.now().plus(this.lifespan).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(now() + lifespan).toString()");
        objectArray[2] = new Tag(expiryKey, string2);
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final List<Tag> tagInitiator() {
        List list;
        String bambooResultKey = System.getenv("bamboo_buildResultKey");
        CharSequence charSequence = bambooResultKey;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            list = CollectionsKt.listOf((Object)new Tag(userKey, InvestmentKt.currentUser()));
        } else {
            Object[] objectArray = new Tag[2];
            objectArray[0] = new Tag(userKey, "bamboo-agent");
            String string = bambooResultKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bambooResultKey");
            objectArray[1] = new Tag(bambooBuildKey, string);
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        return list;
    }

    @NotNull
    public final Duration getLifespan() {
        return this.lifespan;
    }

    @NotNull
    public final Function0<String> getReuseKey() {
        return this.reuseKey;
    }

    private Investment(String useCase, Duration lifespan, boolean disposable, Function0<String> reuseKey2, String resourceOwner) {
        this.useCase = useCase;
        this.lifespan = lifespan;
        this.disposable = disposable;
        this.reuseKey = reuseKey2;
        this.resourceOwner = resourceOwner;
    }

    /* synthetic */ Investment(String string, Duration duration, boolean bl, Function0 function0, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            string2 = defaultResourceOwner;
        }
        this(string, duration, bl, (Function0<String>)function0, string2);
    }

    @Deprecated(message="Use Builder instead. Public constructor will be be removed in the next major version.", replaceWith=@ReplaceWith(imports={}, expression="Investment.Builder(useCase = useCase, lifespan = lifespan).disposable(disposable).reuseKey(reuseKey).build()"))
    public Investment(@NotNull String useCase, @NotNull Duration lifespan, boolean disposable, @NotNull Function0<String> reuseKey2) {
        Intrinsics.checkParameterIsNotNull((Object)useCase, (String)"useCase");
        Intrinsics.checkParameterIsNotNull((Object)lifespan, (String)lifespanKey);
        Intrinsics.checkParameterIsNotNull(reuseKey2, (String)"reuseKey");
        this(useCase, lifespan, disposable, reuseKey2, defaultResourceOwner);
    }

    public /* synthetic */ Investment(String string, Duration duration, boolean bl, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            function0 = 2.INSTANCE;
        }
        this(string, duration, bl, (Function0<String>)function0);
    }

    public /* synthetic */ Investment(String useCase, Duration lifespan, boolean disposable, Function0 reuseKey2, String resourceOwner, DefaultConstructorMarker $constructor_marker) {
        this(useCase, lifespan, disposable, (Function0<String>)reuseKey2, resourceOwner);
    }

    private final String component1() {
        return this.useCase;
    }

    @NotNull
    public final Duration component2() {
        return this.lifespan;
    }

    private final boolean component3() {
        return this.disposable;
    }

    @NotNull
    public final Function0<String> component4() {
        return this.reuseKey;
    }

    private final String component5() {
        return this.resourceOwner;
    }

    @NotNull
    public final Investment copy(@NotNull String useCase, @NotNull Duration lifespan, boolean disposable, @NotNull Function0<String> reuseKey2, @NotNull String resourceOwner) {
        Intrinsics.checkParameterIsNotNull((Object)useCase, (String)"useCase");
        Intrinsics.checkParameterIsNotNull((Object)lifespan, (String)lifespanKey);
        Intrinsics.checkParameterIsNotNull(reuseKey2, (String)"reuseKey");
        Intrinsics.checkParameterIsNotNull((Object)resourceOwner, (String)"resourceOwner");
        return new Investment(useCase, lifespan, disposable, reuseKey2, resourceOwner);
    }

    public static /* synthetic */ Investment copy$default(Investment investment, String string, Duration duration, boolean bl, Function0 function0, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = investment.useCase;
        }
        if ((n & 2) != 0) {
            duration = investment.lifespan;
        }
        if ((n & 4) != 0) {
            bl = investment.disposable;
        }
        if ((n & 8) != 0) {
            function0 = investment.reuseKey;
        }
        if ((n & 0x10) != 0) {
            string2 = investment.resourceOwner;
        }
        return investment.copy(string, duration, bl, function0, string2);
    }

    @NotNull
    public String toString() {
        return "Investment(useCase=" + this.useCase + ", lifespan=" + this.lifespan + ", disposable=" + this.disposable + ", reuseKey=" + this.reuseKey + ", resourceOwner=" + this.resourceOwner + ")";
    }

    public int hashCode() {
        String string = this.useCase;
        Duration duration = this.lifespan;
        int n = ((string != null ? string.hashCode() : 0) * 31 + (duration != null ? ((Object)duration).hashCode() : 0)) * 31;
        int n2 = this.disposable ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        Function0<String> function0 = this.reuseKey;
        String string2 = this.resourceOwner;
        return ((n + n2) * 31 + (function0 != null ? function0.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Investment)) break block3;
                Investment investment = (Investment)object;
                if (!Intrinsics.areEqual((Object)this.useCase, (Object)investment.useCase) || !Intrinsics.areEqual((Object)this.lifespan, (Object)investment.lifespan) || this.disposable != investment.disposable || !Intrinsics.areEqual(this.reuseKey, investment.reuseKey) || !Intrinsics.areEqual((Object)this.resourceOwner, (Object)investment.resourceOwner)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0003J\u0014\u0010\n\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/performance/tools/aws/api/Investment$Builder;", "", "useCase", "", "lifespan", "Ljava/time/Duration;", "(Ljava/lang/String;Ljava/time/Duration;)V", "disposable", "", "resourceOwner", "reuseKey", "Lkotlin/Function0;", "build", "Lcom/atlassian/performance/tools/aws/api/Investment;", "aws-resources"})
    public static final class Builder {
        private boolean disposable;
        private Function0<String> reuseKey;
        private String resourceOwner;
        private final String useCase;
        private final Duration lifespan;

        @NotNull
        public final Builder disposable(boolean disposable) {
            Builder builder;
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.disposable = disposable;
            return builder;
        }

        @NotNull
        public final Builder reuseKey(@NotNull Function0<String> reuseKey2) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(reuseKey2, (String)"reuseKey");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.reuseKey = reuseKey2;
            return builder;
        }

        @NotNull
        public final Builder resourceOwner(@NotNull String resourceOwner) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)resourceOwner, (String)"resourceOwner");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.resourceOwner = resourceOwner;
            return builder;
        }

        @NotNull
        public final Investment build() {
            return new Investment(this.useCase, this.lifespan, this.disposable, this.reuseKey, this.resourceOwner, null);
        }

        public Builder(@NotNull String useCase, @NotNull Duration lifespan) {
            Intrinsics.checkParameterIsNotNull((Object)useCase, (String)"useCase");
            Intrinsics.checkParameterIsNotNull((Object)lifespan, (String)Investment.lifespanKey);
            this.useCase = useCase;
            this.lifespan = lifespan;
            this.disposable = true;
            this.reuseKey = reuseKey.1.INSTANCE;
            this.resourceOwner = Investment.defaultResourceOwner;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/performance/tools/aws/api/Investment$TagKeys;", "", "()V", "bambooBuildKey", "", "defaultResourceOwner", "disposableKey", "expiryKey", "lifespanKey", "userKey", "parseDurationOrNull", "Ljava/time/Duration;", "duration", "parseExpiry", "Ljava/time/Instant;", "tags", "", "Lcom/atlassian/performance/tools/aws/api/Tag;", "parseInstantOrNull", "instant", "parseLifespan", "aws-resources"})
    public static final class TagKeys {
        @Nullable
        public final Duration parseLifespan(@NotNull List<Tag> tags) {
            Iterable $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull(tags, (String)"tags");
            Iterable $receiver$iv = tags;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Tag it = (Tag)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKey(), (Object)Investment.lifespanKey)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Duration duration;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                Tag it = (Tag)element$iv$iv;
                boolean bl = false;
                if (TagKeys.parseDurationOrNull(it.getValue()) == null) continue;
                Duration it$iv$iv = duration;
                destination$iv$iv.add(it$iv$iv);
            }
            return (Duration)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        }

        @Nullable
        public final Instant parseExpiry(@NotNull List<Tag> tags) {
            Iterable $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull(tags, (String)"tags");
            Iterable $receiver$iv = tags;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Tag it = (Tag)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKey(), (Object)Investment.expiryKey)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Instant instant;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                Tag it = (Tag)element$iv$iv;
                boolean bl = false;
                if (TagKeys.parseInstantOrNull(it.getValue()) == null) continue;
                Instant it$iv$iv = instant;
                destination$iv$iv.add(it$iv$iv);
            }
            return (Instant)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        }

        private final Duration parseDurationOrNull(String duration) {
            Duration duration2;
            try {
                duration2 = Duration.parse(duration);
            }
            catch (Exception e) {
                duration2 = null;
            }
            return duration2;
        }

        private final Instant parseInstantOrNull(String instant) {
            Instant instant2;
            try {
                instant2 = Instant.parse(instant);
            }
            catch (Exception e) {
                instant2 = null;
            }
            return instant2;
        }

        private TagKeys() {
        }

        public /* synthetic */ TagKeys(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

