/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.STSAssumeRoleWithWebIdentitySessionCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.retry.PredefinedBackoffStrategies;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClientBuilder;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.AvailabilityZoneState;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClientBuilder;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClientBuilder;
import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.AmazonRDSClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityResult;
import com.atlassian.performance.tools.aws.BatchingCloudformation;
import com.atlassian.performance.tools.aws.Cloudformation;
import com.atlassian.performance.tools.aws.TokenScrollingEc2;
import com.atlassian.performance.tools.aws.api.AwaitingEc2;
import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.CapacityMediator;
import com.atlassian.performance.tools.aws.api.InstanceNanny;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.ProvisionedStack;
import com.atlassian.performance.tools.aws.api.ScrollingCloudformation;
import com.atlassian.performance.tools.aws.api.ScrollingEc2;
import com.atlassian.performance.tools.aws.api.StackFormula;
import com.atlassian.performance.tools.aws.api.StackNanny;
import com.atlassian.performance.tools.aws.api.Storage;
import com.atlassian.performance.tools.aws.api.TerminationBatchingEc2;
import com.atlassian.performance.tools.aws.api.TerminationPollingEc2;
import com.atlassian.performance.tools.aws.api.TextCapacityMediator;
import com.atlassian.performance.tools.aws.api.ami.AmiProvider;
import com.atlassian.performance.tools.aws.api.ami.CanonicalAmiProvider;
import com.atlassian.performance.tools.aws.api.housekeeping.ConcurrentHousekeeping;
import com.atlassian.performance.tools.aws.api.housekeeping.Housekeeping;
import com.atlassian.performance.tools.io.api.ClasspathResourcesKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u00fe\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002\u0088\u0001B=\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB3\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fBw\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00130\u0015\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u0007\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010z\u001a\u00020{J\u0018\u0010z\u001a\u00020{2\u0006\u0010|\u001a\u00020\u000b2\u0006\u0010}\u001a\u00020\u000bH\u0007J\u000e\u0010;\u001a\u00020~2\u0006\u0010\u007f\u001a\u00020\rJ\u0010\u0010\u0080\u0001\u001a\u00020~2\u0007\u0010\u0081\u0001\u001a\u00020\rJ\u000e\u0010\u0082\u0001\u001a\t\u0012\u0005\u0012\u00030\u0083\u00010\u0007J\u0010\u0010\u0084\u0001\u001a\u00020~2\u0007\u0010\u0081\u0001\u001a\u00020\rJ\u0007\u0010\u0085\u0001\u001a\u00020\rJ\u0010\u0010\u0086\u0001\u001a\u00020~2\u0007\u0010\u0081\u0001\u001a\u00020\rJ\r\u0010\u0087\u0001\u001a\u00020\r*\u00020\u0005H\u0002R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00130\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010 \u001a\u00020!8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u001f\u001a\u0004\b\"\u0010#R\u0018\u0010%\u001a\u00060&j\u0002`'X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001c\u0010*\u001a\u00020+8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u00100\u001a\u0002018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u001f\u001a\u0004\b2\u00103R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00105\u001a\u000206\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u001b\u0010;\u001a\u00020<8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010\u001f\u001a\u0004\b=\u0010>R!\u0010@\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\bD\u0010\u001f\u0012\u0004\bA\u0010-\u001a\u0004\bB\u0010CR\u0011\u0010E\u001a\u00020F\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010I\u001a\u00020J\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u0014\u0010M\u001a\u00020NX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010PR\u0011\u0010Q\u001a\u00020R\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010TR\u000e\u0010U\u001a\u00020VX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010W\u001a\u00020X\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010ZR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\\R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010]\u001a\u00020^\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010`R\u000e\u0010a\u001a\u00020bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010c\u001a\u00020dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010e\u001a\u00020<8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bg\u0010\u001f\u001a\u0004\bf\u0010>R\u0011\u0010h\u001a\u00020i\u00a2\u0006\b\n\u0000\u001a\u0004\bj\u0010kR\u0011\u0010l\u001a\u00020m\u00a2\u0006\b\n\u0000\u001a\u0004\bn\u0010oR\u001b\u0010p\u001a\u00020q8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bt\u0010\u001f\u001a\u0004\br\u0010sR\u001b\u0010u\u001a\u00020v8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\by\u0010\u001f\u001a\u0004\bw\u0010x\u00a8\u0006\u0089\u0001"}, d2={"Lcom/atlassian/performance/tools/aws/api/Aws;", "", "credentialsProvider", "Lcom/amazonaws/auth/AWSCredentialsProvider;", "region", "Lcom/amazonaws/regions/Regions;", "regionsWithHousekeeping", "", "capacity", "Lcom/atlassian/performance/tools/aws/api/CapacityMediator;", "batchingCloudformationRefreshPeriod", "Ljava/time/Duration;", "permissionsBoundaryPolicy", "", "(Lcom/amazonaws/auth/AWSCredentialsProvider;Lcom/amazonaws/regions/Regions;Ljava/util/List;Lcom/atlassian/performance/tools/aws/api/CapacityMediator;Ljava/time/Duration;Ljava/lang/String;)V", "(Lcom/amazonaws/regions/Regions;Lcom/amazonaws/auth/AWSCredentialsProvider;Lcom/atlassian/performance/tools/aws/api/CapacityMediator;Ljava/time/Duration;Ljava/lang/String;)V", "housekeeping", "Lcom/atlassian/performance/tools/aws/api/housekeeping/Housekeeping;", "requireHousekeeping", "", "availabilityZoneFilter", "Lkotlin/Function1;", "Lcom/amazonaws/services/ec2/model/AvailabilityZone;", "amiProvider", "Lcom/atlassian/performance/tools/aws/api/ami/AmiProvider;", "managedPolicyArns", "(Lcom/amazonaws/regions/Regions;Lcom/atlassian/performance/tools/aws/api/housekeeping/Housekeeping;Lcom/amazonaws/auth/AWSCredentialsProvider;Lcom/atlassian/performance/tools/aws/api/CapacityMediator;Ljava/time/Duration;Ljava/util/List;ZLkotlin/jvm/functions/Function1;Ljava/lang/String;Lcom/atlassian/performance/tools/aws/api/ami/AmiProvider;Ljava/util/List;)V", "availabilityZones", "getAvailabilityZones", "()Ljava/util/List;", "availabilityZones$delegate", "Lkotlin/Lazy;", "awaitingEc2", "Lcom/atlassian/performance/tools/aws/api/AwaitingEc2;", "getAwaitingEc2", "()Lcom/atlassian/performance/tools/aws/api/AwaitingEc2;", "awaitingEc2$delegate", "batchingCfn", "Lcom/atlassian/performance/tools/aws/BatchingCloudformation;", "Lcom/atlassian/performance/tools/aws/InternalBatchingCloudformation;", "getBatchingCfn$aws_resources", "()Lcom/atlassian/performance/tools/aws/BatchingCloudformation;", "batchingCloudformation", "Lcom/atlassian/performance/tools/aws/api/BatchingCloudformation;", "batchingCloudformation$annotations", "()V", "getBatchingCloudformation", "()Lcom/atlassian/performance/tools/aws/api/BatchingCloudformation;", "callerIdentity", "Lcom/amazonaws/services/securitytoken/model/GetCallerIdentityResult;", "getCallerIdentity", "()Lcom/amazonaws/services/securitytoken/model/GetCallerIdentityResult;", "callerIdentity$delegate", "cloudformation", "Lcom/amazonaws/services/cloudformation/AmazonCloudFormation;", "getCloudformation", "()Lcom/amazonaws/services/cloudformation/AmazonCloudFormation;", "getCredentialsProvider", "()Lcom/amazonaws/auth/AWSCredentialsProvider;", "customDatasetStorage", "Lcom/atlassian/performance/tools/aws/api/ProvisionedStack;", "getCustomDatasetStorage", "()Lcom/atlassian/performance/tools/aws/api/ProvisionedStack;", "customDatasetStorage$delegate", "defaultAmi", "defaultAmi$annotations", "getDefaultAmi", "()Ljava/lang/String;", "defaultAmi$delegate", "ec2", "Lcom/amazonaws/services/ec2/AmazonEC2;", "getEc2", "()Lcom/amazonaws/services/ec2/AmazonEC2;", "iam", "Lcom/amazonaws/services/identitymanagement/AmazonIdentityManagement;", "getIam", "()Lcom/amazonaws/services/identitymanagement/AmazonIdentityManagement;", "instanceNanny", "Lcom/atlassian/performance/tools/aws/api/InstanceNanny;", "getInstanceNanny$aws_resources", "()Lcom/atlassian/performance/tools/aws/api/InstanceNanny;", "loadBalancer", "Lcom/amazonaws/services/elasticloadbalancing/AmazonElasticLoadBalancing;", "getLoadBalancer", "()Lcom/amazonaws/services/elasticloadbalancing/AmazonElasticLoadBalancing;", "logger", "Lorg/apache/logging/log4j/Logger;", "rds", "Lcom/amazonaws/services/rds/AmazonRDS;", "getRds", "()Lcom/amazonaws/services/rds/AmazonRDS;", "getRegion", "()Lcom/amazonaws/regions/Regions;", "s3", "Lcom/amazonaws/services/s3/AmazonS3;", "getS3", "()Lcom/amazonaws/services/s3/AmazonS3;", "scrollingCloudformation", "Lcom/atlassian/performance/tools/aws/api/ScrollingCloudformation;", "scrollingEc2", "Lcom/atlassian/performance/tools/aws/api/ScrollingEc2;", "shortTermStorage", "getShortTermStorage", "shortTermStorage$delegate", "stackNanny", "Lcom/atlassian/performance/tools/aws/api/StackNanny;", "getStackNanny", "()Lcom/atlassian/performance/tools/aws/api/StackNanny;", "sts", "Lcom/amazonaws/services/securitytoken/AWSSecurityTokenService;", "getSts", "()Lcom/amazonaws/services/securitytoken/AWSSecurityTokenService;", "terminationBatchingEc2", "Lcom/atlassian/performance/tools/aws/api/TerminationBatchingEc2;", "getTerminationBatchingEc2", "()Lcom/atlassian/performance/tools/aws/api/TerminationBatchingEc2;", "terminationBatchingEc2$delegate", "terminationPollingEc2", "Lcom/atlassian/performance/tools/aws/api/TerminationPollingEc2;", "getTerminationPollingEc2", "()Lcom/atlassian/performance/tools/aws/api/TerminationPollingEc2;", "terminationPollingEc2$delegate", "cleanLeftovers", "", "stacksReleaseTimeout", "ec2ReleaseTimeout", "Lcom/atlassian/performance/tools/aws/api/Storage;", "datasetName", "jiraStorage", "nonce", "listDisposableStacks", "Lcom/amazonaws/services/cloudformation/model/Stack;", "resultsStorage", "shortTermStorageAccess", "virtualUsersStorage", "describe", "Builder", "aws-resources"})
public final class Aws {
    private final Logger logger;
    @NotNull
    private final AmazonEC2 ec2;
    @NotNull
    private final AmazonS3 s3;
    @NotNull
    private final AmazonRDS rds;
    @NotNull
    private final AmazonCloudFormation cloudformation;
    @NotNull
    private final AmazonIdentityManagement iam;
    @NotNull
    private final AWSSecurityTokenService sts;
    private final ScrollingCloudformation scrollingCloudformation;
    @NotNull
    private final BatchingCloudformation batchingCfn;
    @NotNull
    private final com.atlassian.performance.tools.aws.api.BatchingCloudformation batchingCloudformation;
    private final ScrollingEc2 scrollingEc2;
    private final Lazy terminationPollingEc2$delegate;
    @NotNull
    private final Lazy terminationBatchingEc2$delegate;
    @NotNull
    private final AmazonElasticLoadBalancing loadBalancer;
    @NotNull
    private final StackNanny stackNanny;
    @NotNull
    private final InstanceNanny instanceNanny;
    private final Lazy shortTermStorage$delegate;
    private final Lazy customDatasetStorage$delegate;
    @NotNull
    private final Lazy defaultAmi$delegate;
    @NotNull
    private final Lazy awaitingEc2$delegate;
    @NotNull
    private final Lazy availabilityZones$delegate;
    @NotNull
    private final Lazy callerIdentity$delegate;
    @NotNull
    private final Regions region;
    private final Housekeeping housekeeping;
    @NotNull
    private final AWSCredentialsProvider credentialsProvider;
    private final CapacityMediator capacity;
    private final Duration batchingCloudformationRefreshPeriod;
    private final List<Regions> regionsWithHousekeeping;
    private final boolean requireHousekeeping;
    private final Function1<AvailabilityZone, Boolean> availabilityZoneFilter;
    private final String permissionsBoundaryPolicy;
    private final AmiProvider amiProvider;
    private final List<String> managedPolicyArns;

    @NotNull
    public final AmazonEC2 getEc2() {
        return this.ec2;
    }

    @NotNull
    public final AmazonS3 getS3() {
        return this.s3;
    }

    @NotNull
    public final AmazonRDS getRds() {
        return this.rds;
    }

    @NotNull
    public final AmazonCloudFormation getCloudformation() {
        return this.cloudformation;
    }

    @NotNull
    public final AmazonIdentityManagement getIam() {
        return this.iam;
    }

    @NotNull
    public final AWSSecurityTokenService getSts() {
        return this.sts;
    }

    @NotNull
    public final BatchingCloudformation getBatchingCfn$aws_resources() {
        return this.batchingCfn;
    }

    @Deprecated(message="Don't use batchingCloudformation directly. Use a StackFormula instead.")
    public static /* synthetic */ void batchingCloudformation$annotations() {
    }

    @NotNull
    public final com.atlassian.performance.tools.aws.api.BatchingCloudformation getBatchingCloudformation() {
        return this.batchingCloudformation;
    }

    private final TerminationPollingEc2 getTerminationPollingEc2() {
        Lazy lazy = this.terminationPollingEc2$delegate;
        Aws aws = this;
        Object var3_3 = null;
        return (TerminationPollingEc2)lazy.getValue();
    }

    @NotNull
    public final TerminationBatchingEc2 getTerminationBatchingEc2() {
        Lazy lazy = this.terminationBatchingEc2$delegate;
        Aws aws = this;
        Object var3_3 = null;
        return (TerminationBatchingEc2)lazy.getValue();
    }

    @NotNull
    public final AmazonElasticLoadBalancing getLoadBalancer() {
        return this.loadBalancer;
    }

    @NotNull
    public final StackNanny getStackNanny() {
        return this.stackNanny;
    }

    @NotNull
    public final InstanceNanny getInstanceNanny$aws_resources() {
        return this.instanceNanny;
    }

    private final ProvisionedStack getShortTermStorage() {
        Lazy lazy = this.shortTermStorage$delegate;
        Aws aws = this;
        Object var3_3 = null;
        return (ProvisionedStack)lazy.getValue();
    }

    private final ProvisionedStack getCustomDatasetStorage() {
        Lazy lazy = this.customDatasetStorage$delegate;
        Aws aws = this;
        Object var3_3 = null;
        return (ProvisionedStack)lazy.getValue();
    }

    public static /* synthetic */ void defaultAmi$annotations() {
    }

    @NotNull
    public final String getDefaultAmi() {
        Lazy lazy = this.defaultAmi$delegate;
        Aws aws = this;
        Object var3_3 = null;
        return (String)lazy.getValue();
    }

    @NotNull
    public final AwaitingEc2 getAwaitingEc2() {
        Lazy lazy = this.awaitingEc2$delegate;
        Aws aws = this;
        Object var3_3 = null;
        return (AwaitingEc2)lazy.getValue();
    }

    @NotNull
    public final List<AvailabilityZone> getAvailabilityZones() {
        Lazy lazy = this.availabilityZones$delegate;
        Aws aws = this;
        Object var3_3 = null;
        return (List)lazy.getValue();
    }

    @NotNull
    public final GetCallerIdentityResult getCallerIdentity() {
        Lazy lazy = this.callerIdentity$delegate;
        Aws aws = this;
        Object var3_3 = null;
        return (GetCallerIdentityResult)lazy.getValue();
    }

    @NotNull
    public final Storage jiraStorage(@NotNull String nonce) {
        Intrinsics.checkParameterIsNotNull((Object)nonce, (String)"nonce");
        return this.getShortTermStorage().findStorage("JiraBucket", nonce);
    }

    @NotNull
    public final Storage virtualUsersStorage(@NotNull String nonce) {
        Intrinsics.checkParameterIsNotNull((Object)nonce, (String)"nonce");
        return this.getShortTermStorage().findStorage("VirtualUsersBucket", nonce);
    }

    @NotNull
    public final Storage resultsStorage(@NotNull String nonce) {
        Intrinsics.checkParameterIsNotNull((Object)nonce, (String)"nonce");
        return this.getShortTermStorage().findStorage("ResultsBucket", nonce);
    }

    @NotNull
    public final String shortTermStorageAccess() {
        return this.getShortTermStorage().findInstanceProfile("AccessProfile");
    }

    @NotNull
    public final Storage customDatasetStorage(@NotNull String datasetName) {
        Intrinsics.checkParameterIsNotNull((Object)datasetName, (String)"datasetName");
        return this.getCustomDatasetStorage().findStorage("DatasetBucket", datasetName);
    }

    public final void cleanLeftovers() {
        this.housekeeping.cleanLeftovers(this);
    }

    @Deprecated(message="Use cleanLeftovers() instead. You can use ConcurrentHousekeeping.Builder and inject it via Aws.Builder.housekeeping", replaceWith=@ReplaceWith(imports={}, expression="cleanLeftovers()"))
    public final void cleanLeftovers(@NotNull Duration stacksReleaseTimeout, @NotNull Duration ec2ReleaseTimeout) {
        Intrinsics.checkParameterIsNotNull((Object)stacksReleaseTimeout, (String)"stacksReleaseTimeout");
        Intrinsics.checkParameterIsNotNull((Object)ec2ReleaseTimeout, (String)"ec2ReleaseTimeout");
        new ConcurrentHousekeeping.Builder().stackTimeout(stacksReleaseTimeout).instanceTimeout(ec2ReleaseTimeout).build().cleanLeftovers(this);
    }

    @NotNull
    public final List<Stack> listDisposableStacks() {
        return new Cloudformation(this, this.cloudformation).listDisposableStacks();
    }

    private final String describe(Regions $receiver) {
        return $receiver.name() + " (" + $receiver.getDescription() + ')';
    }

    @NotNull
    public final Regions getRegion() {
        return this.region;
    }

    @NotNull
    public final AWSCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    private Aws(Regions region, Housekeeping housekeeping, AWSCredentialsProvider credentialsProvider, CapacityMediator capacity, Duration batchingCloudformationRefreshPeriod, List<? extends Regions> regionsWithHousekeeping, boolean requireHousekeeping, Function1<? super AvailabilityZone, Boolean> availabilityZoneFilter2, String permissionsBoundaryPolicy, AmiProvider amiProvider, List<String> managedPolicyArns) {
        this.region = region;
        this.housekeeping = housekeeping;
        this.credentialsProvider = credentialsProvider;
        this.capacity = capacity;
        this.batchingCloudformationRefreshPeriod = batchingCloudformationRefreshPeriod;
        this.regionsWithHousekeeping = regionsWithHousekeeping;
        this.requireHousekeeping = requireHousekeeping;
        this.availabilityZoneFilter = availabilityZoneFilter2;
        this.permissionsBoundaryPolicy = permissionsBoundaryPolicy;
        this.amiProvider = amiProvider;
        this.managedPolicyArns = managedPolicyArns;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        Object object = ((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withRegion(this.region)).withCredentials(this.credentialsProvider)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"AmazonEC2ClientBuilder.s\u2026rovider)\n        .build()");
        this.ec2 = (AmazonEC2)object;
        Object object2 = ((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(this.region)).withCredentials(this.credentialsProvider)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"AmazonS3ClientBuilder.st\u2026rovider)\n        .build()");
        this.s3 = (AmazonS3)object2;
        Object object3 = ((AmazonRDSClientBuilder)((AmazonRDSClientBuilder)AmazonRDSClientBuilder.standard().withRegion(this.region)).withCredentials(this.credentialsProvider)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"AmazonRDSClientBuilder.s\u2026rovider)\n        .build()");
        this.rds = (AmazonRDS)object3;
        Object object4 = ((AmazonCloudFormationClientBuilder)((AmazonCloudFormationClientBuilder)((AmazonCloudFormationClientBuilder)AmazonCloudFormationClientBuilder.standard().withRegion(this.region)).withCredentials(this.credentialsProvider)).withClientConfiguration(new ClientConfiguration().withRetryPolicy(new RetryPolicy(PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION, (RetryPolicy.BackoffStrategy)new PredefinedBackoffStrategies.EqualJitterBackoffStrategy((int)Duration.ofSeconds(2L).toMillis(), (int)Duration.ofMinutes(3L).toMillis()), 6, false)))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"AmazonCloudFormationClie\u2026       )\n        .build()");
        this.cloudformation = (AmazonCloudFormation)object4;
        Object object5 = ((AmazonIdentityManagementClientBuilder)((AmazonIdentityManagementClientBuilder)AmazonIdentityManagementClientBuilder.standard().withRegion(this.region)).withCredentials(this.credentialsProvider)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"AmazonIdentityManagement\u2026rovider)\n        .build()");
        this.iam = (AmazonIdentityManagement)object5;
        Object object6 = ((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(this.region)).withCredentials(this.credentialsProvider)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object6, (String)"AWSSecurityTokenServiceC\u2026rovider)\n        .build()");
        this.sts = (AWSSecurityTokenService)object6;
        this.scrollingCloudformation = new ScrollingCloudformation(this.cloudformation);
        this.batchingCfn = new BatchingCloudformation(this.scrollingCloudformation, this.batchingCloudformationRefreshPeriod);
        this.batchingCloudformation = new com.atlassian.performance.tools.aws.api.BatchingCloudformation(this.scrollingCloudformation);
        this.scrollingEc2 = new TokenScrollingEc2(this.ec2);
        this.terminationPollingEc2$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TerminationPollingEc2>(this){
            final /* synthetic */ Aws this$0;

            @NotNull
            public final TerminationPollingEc2 invoke() {
                return new TerminationPollingEc2(Aws.access$getScrollingEc2$p(this.this$0));
            }
            {
                this.this$0 = aws;
                super(0);
            }
        }));
        this.terminationBatchingEc2$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TerminationBatchingEc2>(this){
            final /* synthetic */ Aws this$0;

            @NotNull
            public final TerminationBatchingEc2 invoke() {
                return new TerminationBatchingEc2(this.this$0.getEc2(), Aws.access$getTerminationPollingEc2$p(this.this$0));
            }
            {
                this.this$0 = aws;
                super(0);
            }
        }));
        Object object7 = ((AmazonElasticLoadBalancingClientBuilder)((AmazonElasticLoadBalancingClientBuilder)AmazonElasticLoadBalancingClientBuilder.standard().withRegion(this.region)).withCredentials(this.credentialsProvider)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object7, (String)"AmazonElasticLoadBalanci\u2026rovider)\n        .build()");
        this.loadBalancer = (AmazonElasticLoadBalancing)object7;
        this.stackNanny = new StackNanny(this.cloudformation, this.scrollingEc2, this.capacity);
        this.instanceNanny = new InstanceNanny(this.scrollingEc2, this.capacity);
        this.shortTermStorage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProvisionedStack>(this){
            final /* synthetic */ Aws this$0;

            @NotNull
            public final ProvisionedStack invoke() {
                Duration duration = Duration.ofDays(30L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofDays(30)");
                Duration duration2 = null;
                Duration duration3 = null;
                Aws aws = this.this$0;
                List list = CollectionsKt.listOf((Object[])new Parameter[]{new Parameter().withParameterKey("PermissionBoundaryPolicyARN").withParameterValue(Aws.access$getPermissionsBoundaryPolicy$p(this.this$0)), new Parameter().withParameterKey("PolicyArns").withParameterValue(CollectionsKt.joinToString$default((Iterable)Aws.access$getManagedPolicyArns$p(this.this$0), (CharSequence)",", null, null, (int)0, null, null, (int)62, null))});
                String string = ClasspathResourcesKt.readResourceText((String)"aws/short-term-storage.yaml");
                return new StackFormula(new Investment.Builder("Transport files necessary to run the tests", duration).disposable(false).reuseKey((Function0<String>)((Function0)shortTermStorage.1.INSTANCE)).build(), aws, string, list, duration3, duration2, 48, null).provision();
            }
            {
                this.this$0 = aws;
                super(0);
            }
        }));
        this.customDatasetStorage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProvisionedStack>(this){
            final /* synthetic */ Aws this$0;

            @NotNull
            public final ProvisionedStack invoke() {
                Duration duration = Duration.ofDays(800L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofDays(800)");
                Duration duration2 = null;
                Duration duration3 = null;
                List list = null;
                Aws aws = this.this$0;
                String string = ClasspathResourcesKt.readResourceText((String)"aws/custom-datasets-storage.yaml");
                return new StackFormula(new Investment.Builder("Store custom datasets", duration).disposable(false).reuseKey((Function0<String>)((Function0)customDatasetStorage.1.INSTANCE)).build(), aws, string, list, duration3, duration2, 56, null).provision();
            }
            {
                this.this$0 = aws;
                super(0);
            }
        }));
        this.defaultAmi$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Aws this$0;

            @NotNull
            public final String invoke() {
                return Aws.access$getAmiProvider$p(this.this$0).provideAmiId(this.this$0);
            }
            {
                this.this$0 = aws;
                super(0);
            }
        }));
        this.awaitingEc2$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AwaitingEc2>(this){
            final /* synthetic */ Aws this$0;

            @NotNull
            public final AwaitingEc2 invoke() {
                return new AwaitingEc2(this.this$0.getEc2(), this.this$0.getTerminationBatchingEc2(), this.this$0.getInstanceNanny$aws_resources(), this.this$0.getDefaultAmi());
            }
            {
                this.this$0 = aws;
                super(0);
            }
        }));
        this.availabilityZones$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends AvailabilityZone>>(this){
            final /* synthetic */ Aws this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<AvailabilityZone> invoke() {
                void $receiver$iv$iv;
                void $receiver$iv$iv2;
                DescribeAvailabilityZonesResult describeAvailabilityZonesResult = this.this$0.getEc2().describeAvailabilityZones();
                Intrinsics.checkExpressionValueIsNotNull((Object)describeAvailabilityZonesResult, (String)"ec2\n            .describeAvailabilityZones()");
                List list = describeAvailabilityZonesResult.getAvailabilityZones();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ec2\n            .describ\u2026       .availabilityZones");
                Iterable $receiver$iv = list;
                Iterable iterable = $receiver$iv;
                Iterable<T> destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv2) {
                    AvailabilityZone it = (AvailabilityZone)element$iv$iv;
                    boolean bl = false;
                    AvailabilityZone availabilityZone = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)availabilityZone, (String)"it");
                    if (!(AvailabilityZoneState.fromValue((String)availabilityZone.getState()) == AvailabilityZoneState.Available)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                Function1 predicate$iv = Aws.access$getAvailabilityZoneFilter$p(this.this$0);
                destination$iv$iv = $receiver$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                return (List)destination$iv$iv2;
            }
            {
                this.this$0 = aws;
                super(0);
            }
        }));
        this.callerIdentity$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GetCallerIdentityResult>(this){
            final /* synthetic */ Aws this$0;

            public final GetCallerIdentityResult invoke() {
                return this.this$0.getSts().getCallerIdentity(new GetCallerIdentityRequest());
            }
            {
                this.this$0 = aws;
                super(0);
            }
        }));
        if (!this.regionsWithHousekeeping.contains(this.region)) {
            String message = StringsKt.trimIndent((String)("\n                *************************************************************************************************\n\n                ATTENTION!\n                YOU RISK LOSING MONEY on unnecessary AWS charges if you don't clean up AWS resources in\n                the " + this.describe(this.region) + " AWS region.\n\n                All AWS resources provisioned by this code are marked with a `lifespan` or `expiry` tag/metadata.\n                You can control that duration via the `Investment` class.\n                After a resource is past its lifespan/expiry, it is eligible for cleanup by any housekeeping call.\n                You can invoke housekeeping via the `cleanLeftovers` method on this object.\n                Make sure the `region` set in the constructor equals " + this.region + ".\n                Run this housekeeping periodically, for example every 30 minutes. A CI server or cron can work.\n\n                When you do ensure that this region has housekeeping taken care of, you can get rid of this error,\n                by adding the region to the `regionsWithHousekeeping` list in the constructor.\n\n                **************************************************************************************************\n            "));
            if (this.requireHousekeeping) {
                throw (Throwable)new Exception(message);
            }
            this.logger.error(message);
        }
        Function1 function1 = null;
        CharSequence charSequence = null;
        int n = 0;
        CharSequence charSequence2 = null;
        CharSequence charSequence3 = "\n";
        CharSequence charSequence4 = "- ";
        String safeRegionsList = CollectionsKt.joinToString$default((Iterable)this.regionsWithHousekeeping, (CharSequence)charSequence3, (CharSequence)charSequence4, charSequence2, (int)n, charSequence, function1, (int)60, null);
        this.logger.info(StringsKt.trimIndent((String)("\n                You already declared that AWS housekeeping is taken care of in the following regions:\n                " + safeRegionsList + "\n                Make sure this list makes sense from time to time.\n            ")));
    }

    @Deprecated(message="Use Builder instead.", replaceWith=@ReplaceWith(imports={}, expression="Aws.Builder(region = region).credentialsProvider(credentialsProvider).regionsWithHousekeeping(regionsWithHousekeeping).capacity(capacity).batchingCloudformationRefreshPeriod(batchingCloudformationRefreshPeriod).build()"))
    public Aws(@NotNull AWSCredentialsProvider credentialsProvider, @NotNull Regions region, @NotNull List<? extends Regions> regionsWithHousekeeping, @NotNull CapacityMediator capacity, @NotNull Duration batchingCloudformationRefreshPeriod, @NotNull String permissionsBoundaryPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)credentialsProvider, (String)"credentialsProvider");
        Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
        Intrinsics.checkParameterIsNotNull(regionsWithHousekeeping, (String)"regionsWithHousekeeping");
        Intrinsics.checkParameterIsNotNull((Object)capacity, (String)"capacity");
        Intrinsics.checkParameterIsNotNull((Object)batchingCloudformationRefreshPeriod, (String)"batchingCloudformationRefreshPeriod");
        Intrinsics.checkParameterIsNotNull((Object)permissionsBoundaryPolicy, (String)"permissionsBoundaryPolicy");
        List list = CollectionsKt.emptyList();
        Housekeeping housekeeping = new ConcurrentHousekeeping.Builder().build();
        AmiProvider amiProvider = new CanonicalAmiProvider.Builder().build();
        String string = permissionsBoundaryPolicy;
        Function1 function1 = 1.INSTANCE;
        boolean bl = true;
        List<? extends Regions> list2 = regionsWithHousekeeping;
        Duration duration = batchingCloudformationRefreshPeriod;
        CapacityMediator capacityMediator = capacity;
        AWSCredentialsProvider aWSCredentialsProvider = credentialsProvider;
        this(region, housekeeping, aWSCredentialsProvider, capacityMediator, duration, list2, bl, (Function1<? super AvailabilityZone, Boolean>)function1, string, amiProvider, list);
    }

    @Deprecated(message="Use Builder instead. This constructor is unsafe, because it doesn't fail-fast for missing AWS housekeeping declarations. It's left here only for compatibility. Move away from it as fast as possible.", replaceWith=@ReplaceWith(imports={}, expression="Aws.Builder(region = region).credentialsProvider(credentialsProvider).capacity(capacity).batchingCloudformationRefreshPeriod(batchingCloudformationRefreshPeriod).build()"))
    @JvmOverloads
    public Aws(@NotNull Regions region, @NotNull AWSCredentialsProvider credentialsProvider, @NotNull CapacityMediator capacity, @NotNull Duration batchingCloudformationRefreshPeriod, @NotNull String permissionsBoundaryPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
        Intrinsics.checkParameterIsNotNull((Object)credentialsProvider, (String)"credentialsProvider");
        Intrinsics.checkParameterIsNotNull((Object)capacity, (String)"capacity");
        Intrinsics.checkParameterIsNotNull((Object)batchingCloudformationRefreshPeriod, (String)"batchingCloudformationRefreshPeriod");
        Intrinsics.checkParameterIsNotNull((Object)permissionsBoundaryPolicy, (String)"permissionsBoundaryPolicy");
        List list = CollectionsKt.emptyList();
        Housekeeping housekeeping = new ConcurrentHousekeeping.Builder().build();
        AmiProvider amiProvider = new CanonicalAmiProvider.Builder().build();
        String string = permissionsBoundaryPolicy;
        Function1 function1 = 2.INSTANCE;
        boolean bl = false;
        List list2 = CollectionsKt.emptyList();
        Duration duration = batchingCloudformationRefreshPeriod;
        CapacityMediator capacityMediator = capacity;
        AWSCredentialsProvider aWSCredentialsProvider = credentialsProvider;
        this(region, housekeeping, aWSCredentialsProvider, capacityMediator, duration, list2, bl, (Function1<? super AvailabilityZone, Boolean>)function1, string, amiProvider, list);
    }

    public /* synthetic */ Aws(Regions regions, AWSCredentialsProvider aWSCredentialsProvider, CapacityMediator capacityMediator, Duration duration, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            capacityMediator = new TextCapacityMediator(regions);
        }
        if ((n & 8) != 0) {
            Duration duration2 = Duration.ofMinutes(1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMinutes(1)");
            duration = duration2;
        }
        this(regions, aWSCredentialsProvider, capacityMediator, duration, string);
    }

    @Deprecated(message="Use Builder instead. This constructor is unsafe, because it doesn't fail-fast for missing AWS housekeeping declarations. It's left here only for compatibility. Move away from it as fast as possible.", replaceWith=@ReplaceWith(imports={}, expression="Aws.Builder(region = region).credentialsProvider(credentialsProvider).capacity(capacity).batchingCloudformationRefreshPeriod(batchingCloudformationRefreshPeriod).build()"))
    @JvmOverloads
    public Aws(@NotNull Regions region, @NotNull AWSCredentialsProvider credentialsProvider, @NotNull CapacityMediator capacity, @NotNull String permissionsBoundaryPolicy) {
        this(region, credentialsProvider, capacity, null, permissionsBoundaryPolicy, 8, null);
    }

    @Deprecated(message="Use Builder instead. This constructor is unsafe, because it doesn't fail-fast for missing AWS housekeeping declarations. It's left here only for compatibility. Move away from it as fast as possible.", replaceWith=@ReplaceWith(imports={}, expression="Aws.Builder(region = region).credentialsProvider(credentialsProvider).capacity(capacity).batchingCloudformationRefreshPeriod(batchingCloudformationRefreshPeriod).build()"))
    @JvmOverloads
    public Aws(@NotNull Regions region, @NotNull AWSCredentialsProvider credentialsProvider, @NotNull String permissionsBoundaryPolicy) {
        this(region, credentialsProvider, null, null, permissionsBoundaryPolicy, 12, null);
    }

    public /* synthetic */ Aws(Regions region, Housekeeping housekeeping, AWSCredentialsProvider credentialsProvider, CapacityMediator capacity, Duration batchingCloudformationRefreshPeriod, List regionsWithHousekeeping, boolean requireHousekeeping, Function1 availabilityZoneFilter2, String permissionsBoundaryPolicy, AmiProvider amiProvider, List managedPolicyArns, DefaultConstructorMarker $constructor_marker) {
        this(region, housekeeping, credentialsProvider, capacity, batchingCloudformationRefreshPeriod, regionsWithHousekeeping, requireHousekeeping, (Function1<? super AvailabilityZone, Boolean>)availabilityZoneFilter2, permissionsBoundaryPolicy, amiProvider, managedPolicyArns);
    }

    public static final /* synthetic */ ScrollingEc2 access$getScrollingEc2$p(Aws $this) {
        return $this.scrollingEc2;
    }

    public static final /* synthetic */ TerminationPollingEc2 access$getTerminationPollingEc2$p(Aws $this) {
        return $this.getTerminationPollingEc2();
    }

    public static final /* synthetic */ Function1 access$getAvailabilityZoneFilter$p(Aws $this) {
        return $this.availabilityZoneFilter;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\u00020\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0017J\u0014\u0010\u0019\u001a\u00020\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/performance/tools/aws/api/Aws$Builder;", "", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "(Lcom/atlassian/performance/tools/aws/api/Aws;)V", "region", "Lcom/amazonaws/regions/Regions;", "(Lcom/amazonaws/regions/Regions;)V", "amiProvider", "Lcom/atlassian/performance/tools/aws/api/ami/AmiProvider;", "availabilityZoneFilter", "Ljava/util/function/Predicate;", "Lcom/amazonaws/services/ec2/model/AvailabilityZone;", "batchingCloudformationRefreshPeriod", "Ljava/time/Duration;", "capacity", "Lcom/atlassian/performance/tools/aws/api/CapacityMediator;", "credentialsProvider", "Lcom/amazonaws/auth/AWSCredentialsProvider;", "housekeeping", "Lcom/atlassian/performance/tools/aws/api/housekeeping/Housekeeping;", "managedPolicyArns", "", "", "permissionsBoundaryPolicy", "regionsWithHousekeeping", "build", "aws-resources"})
    public static final class Builder {
        private AWSCredentialsProvider credentialsProvider;
        private List<? extends Regions> regionsWithHousekeeping;
        private CapacityMediator capacity;
        private Duration batchingCloudformationRefreshPeriod;
        private Predicate<AvailabilityZone> availabilityZoneFilter;
        private String permissionsBoundaryPolicy;
        private AmiProvider amiProvider;
        private Housekeeping housekeeping;
        private List<String> managedPolicyArns;
        private final Regions region;

        @NotNull
        public final Builder credentialsProvider(@NotNull AWSCredentialsProvider credentialsProvider) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)credentialsProvider, (String)"credentialsProvider");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.credentialsProvider = credentialsProvider;
            return builder;
        }

        @NotNull
        public final Builder regionsWithHousekeeping(@NotNull List<? extends Regions> regionsWithHousekeeping) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(regionsWithHousekeeping, (String)"regionsWithHousekeeping");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.regionsWithHousekeeping = regionsWithHousekeeping;
            return builder;
        }

        @NotNull
        public final Builder capacity(@NotNull CapacityMediator capacity) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)capacity, (String)"capacity");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.capacity = capacity;
            return builder;
        }

        @NotNull
        public final Builder batchingCloudformationRefreshPeriod(@NotNull Duration batchingCloudformationRefreshPeriod) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)batchingCloudformationRefreshPeriod, (String)"batchingCloudformationRefreshPeriod");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.batchingCloudformationRefreshPeriod = batchingCloudformationRefreshPeriod;
            return builder;
        }

        @NotNull
        public final Builder availabilityZoneFilter(@NotNull Predicate<AvailabilityZone> availabilityZoneFilter2) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(availabilityZoneFilter2, (String)"availabilityZoneFilter");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.availabilityZoneFilter = availabilityZoneFilter2;
            return builder;
        }

        @NotNull
        public final Builder permissionsBoundaryPolicy(@NotNull String permissionsBoundaryPolicy) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)permissionsBoundaryPolicy, (String)"permissionsBoundaryPolicy");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.permissionsBoundaryPolicy = permissionsBoundaryPolicy;
            return builder;
        }

        @NotNull
        public final Builder amiProvider(@NotNull AmiProvider amiProvider) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)amiProvider, (String)"amiProvider");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.amiProvider = amiProvider;
            return builder;
        }

        @NotNull
        public final Builder housekeeping(@NotNull Housekeeping housekeeping) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)housekeeping, (String)"housekeeping");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.housekeeping = housekeeping;
            return builder;
        }

        @NotNull
        public final Builder managedPolicyArns(@NotNull List<String> managedPolicyArns) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(managedPolicyArns, (String)"managedPolicyArns");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.managedPolicyArns = managedPolicyArns;
            return builder;
        }

        @NotNull
        public final Aws build() {
            List<String> list = this.managedPolicyArns;
            Housekeeping housekeeping = this.housekeeping;
            AmiProvider amiProvider = this.amiProvider;
            String string = this.permissionsBoundaryPolicy;
            Function1 function1 = (Function1)new Function1<AvailabilityZone, Boolean>(this){
                final /* synthetic */ Builder this$0;

                public final boolean invoke(@NotNull AvailabilityZone it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Builder.access$getAvailabilityZoneFilter$p(this.this$0).test(it);
                }
                {
                    this.this$0 = builder;
                    super(1);
                }
            };
            boolean bl = true;
            List<? extends Regions> list2 = this.regionsWithHousekeeping;
            Duration duration = this.batchingCloudformationRefreshPeriod;
            CapacityMediator capacityMediator = this.capacity;
            AWSCredentialsProvider aWSCredentialsProvider = this.credentialsProvider;
            return new Aws(this.region, housekeeping, aWSCredentialsProvider, capacityMediator, duration, list2, bl, function1, string, amiProvider, list, null);
        }

        public Builder(@NotNull Regions region) {
            Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
            this.region = region;
            this.credentialsProvider = (AWSCredentialsProvider)new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{(AWSCredentialsProvider)new STSAssumeRoleWithWebIdentitySessionCredentialsProvider.Builder("arn:aws:iam::695067801333:role/jpt-bitbucket-pipelines", UUID.randomUUID().toString(), "web-identity-token").withStsClient((AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(this.region)).build()).build(), (AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain()});
            this.regionsWithHousekeeping = CollectionsKt.emptyList();
            this.capacity = new TextCapacityMediator(this.region);
            Duration duration = Duration.ofMinutes(1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(1)");
            this.batchingCloudformationRefreshPeriod = duration;
            this.availabilityZoneFilter = availabilityZoneFilter.1.INSTANCE;
            this.permissionsBoundaryPolicy = "";
            this.amiProvider = new CanonicalAmiProvider.Builder().build();
            this.housekeeping = new ConcurrentHousekeeping.Builder().build();
            this.managedPolicyArns = CollectionsKt.emptyList();
        }

        public Builder(@NotNull Aws aws) {
            Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
            this(aws.getRegion());
            this.housekeeping = aws.housekeeping;
            this.credentialsProvider = aws.getCredentialsProvider();
            this.capacity = aws.capacity;
            this.batchingCloudformationRefreshPeriod = aws.batchingCloudformationRefreshPeriod;
            this.regionsWithHousekeeping = aws.regionsWithHousekeeping;
            this.availabilityZoneFilter = new Predicate<AvailabilityZone>(){

                @Override
                public final boolean test(@NotNull AvailabilityZone it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return availabilityZoneFilter.test(it);
                }
            };
            this.permissionsBoundaryPolicy = aws.permissionsBoundaryPolicy;
            this.amiProvider = aws.amiProvider;
            this.managedPolicyArns = aws.managedPolicyArns;
        }

        public static final /* synthetic */ void access$setAvailabilityZoneFilter$p(Builder $this, Predicate predicate) {
            $this.availabilityZoneFilter = predicate;
        }
    }
}

