/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.CreateSecurityGroupResult;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.ResourceType;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.ShutdownBehavior;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.waiters.WaiterParameters;
import com.atlassian.performance.tools.aws.Ec2Instance;
import com.atlassian.performance.tools.aws.Ec2SshAccess;
import com.atlassian.performance.tools.aws.api.DependentResources;
import com.atlassian.performance.tools.aws.api.Ec2SecurityGroup;
import com.atlassian.performance.tools.aws.api.InstanceNanny;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.SshInstance;
import com.atlassian.performance.tools.aws.api.SshKey;
import com.atlassian.performance.tools.aws.api.SshKeyFile;
import com.atlassian.performance.tools.aws.api.Tag;
import com.atlassian.performance.tools.aws.api.TerminationBatchingEc2;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshHost;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0015j\u0002`\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0016H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/performance/tools/aws/api/AwaitingEc2;", "", "ec2", "Lcom/amazonaws/services/ec2/AmazonEC2;", "terminationBatchingEc2", "Lcom/atlassian/performance/tools/aws/api/TerminationBatchingEc2;", "instanceNanny", "Lcom/atlassian/performance/tools/aws/api/InstanceNanny;", "defaultAmi", "", "(Lcom/amazonaws/services/ec2/AmazonEC2;Lcom/atlassian/performance/tools/aws/api/TerminationBatchingEc2;Lcom/atlassian/performance/tools/aws/api/InstanceNanny;Ljava/lang/String;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "allocateInstance", "Lcom/atlassian/performance/tools/aws/api/SshInstance;", "investment", "Lcom/atlassian/performance/tools/aws/api/Investment;", "key", "Lcom/atlassian/performance/tools/aws/api/SshKey;", "vpcId", "customizeLaunch", "Lkotlin/Function1;", "Lcom/amazonaws/services/ec2/model/RunInstancesRequest;", "Lcom/atlassian/performance/tools/aws/api/InstanceLaunchMod;", "allocateSecurityGroup", "Lcom/amazonaws/services/ec2/model/SecurityGroup;", "request", "Lcom/amazonaws/services/ec2/model/CreateSecurityGroupRequest;", "launchDefaults", "sshAccess", "startInstance", "Lcom/amazonaws/services/ec2/model/DescribeInstancesRequest;", "launch", "aws-resources"})
public final class AwaitingEc2 {
    private final Logger logger;
    private final AmazonEC2 ec2;
    private final TerminationBatchingEc2 terminationBatchingEc2;
    private final InstanceNanny instanceNanny;
    private final String defaultAmi;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SshInstance allocateInstance(@NotNull Investment investment, @NotNull SshKey key, @Nullable String vpcId, @NotNull Function1<? super RunInstancesRequest, ? extends RunInstancesRequest> customizeLaunch) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)investment, (String)"investment");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(customizeLaunch, (String)"customizeLaunch");
        SecurityGroup sshAccess = new Ec2SshAccess(this.ec2, this).getSecurityGroup(investment, vpcId);
        RunInstancesRequest launchRequest = (RunInstancesRequest)customizeLaunch.invoke((Object)this.launchDefaults(key, investment, sshAccess));
        DescribeInstancesRequest startingInstance = this.startInstance(launchRequest);
        this.ec2.waiters().instanceRunning().run(new WaiterParameters((AmazonWebServiceRequest)startingInstance));
        DescribeInstancesResult describeInstancesResult = this.ec2.describeInstances(startingInstance);
        Intrinsics.checkExpressionValueIsNotNull((Object)describeInstancesResult, (String)"ec2\n            .describ\u2026stances(startingInstance)");
        List list = describeInstancesResult.getReservations();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ec2\n            .describ\u2026            .reservations");
        Iterable iterable = list;
        void var10_9 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Reservation it = (Reservation)element$iv$iv;
            boolean bl = false;
            Reservation reservation = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)reservation, (String)"it");
            Iterable list$iv$iv = reservation.getInstances();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Instance startedInstance = (Instance)CollectionsKt.single((List)((List)destination$iv$iv));
        SshKeyFile sshKeyFile = key.getFile();
        Instance instance = startedInstance;
        Intrinsics.checkExpressionValueIsNotNull((Object)instance, (String)"startedInstance");
        String string = instance.getPublicIpAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"startedInstance.publicIpAddress");
        sshKeyFile.facilitateSsh(string);
        String string2 = startedInstance.getPublicIpAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"startedInstance.publicIpAddress");
        String string3 = launchRequest.getAdditionalInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"launchRequest.additionalInfo");
        return new SshInstance(new Ssh(new SshHost(string2, string3, key.getFile().getPath()), 4), new DependentResources(new Ec2Instance(startedInstance, this.terminationBatchingEc2), new Ec2SecurityGroup(sshAccess, this.ec2)), startedInstance);
    }

    /*
     * WARNING - void declaration
     */
    private final RunInstancesRequest launchDefaults(SshKey key, Investment investment, SecurityGroup sshAccess) {
        Collection<com.amazonaws.services.ec2.model.Tag> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        TagSpecification[] tagSpecificationArray;
        Iterable iterable = investment.tag();
        TagSpecification tagSpecification = new TagSpecification().withResourceType(ResourceType.Instance);
        int n = 0;
        TagSpecification[] tagSpecificationArray2 = tagSpecificationArray = new TagSpecification[1];
        RunInstancesRequest runInstancesRequest = new RunInstancesRequest().withMinCount(Integer.valueOf(1)).withMaxCount(Integer.valueOf(1)).withInstanceType(InstanceType.T3Nano).withImageId(this.defaultAmi).withAdditionalInfo("ubuntu").withInstanceInitiatedShutdownBehavior(ShutdownBehavior.Terminate).withKeyName(key.getRemote().getName()).withSecurityGroupIds(new String[]{sshAccess.getGroupId()});
        void var5_10 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Tag tag = (Tag)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            com.amazonaws.services.ec2.model.Tag tag2 = it.toEc2();
            collection.add(tag2);
        }
        collection = (List)destination$iv$iv;
        tagSpecificationArray[n] = tagSpecification.withTags((Collection)collection);
        RunInstancesRequest runInstancesRequest2 = runInstancesRequest.withTagSpecifications(tagSpecificationArray2);
        Intrinsics.checkExpressionValueIsNotNull((Object)runInstancesRequest2, (String)"RunInstancesRequest()\n  \u2026.toEc2() })\n            )");
        return runInstancesRequest2;
    }

    private final DescribeInstancesRequest startInstance(RunInstancesRequest launch) {
        RunInstancesResult response;
        RunInstancesResult runInstancesResult;
        try {
            runInstancesResult = this.ec2.runInstances(launch);
        }
        catch (Exception e) {
            runInstancesResult = this.instanceNanny.takeCare(e, launch);
        }
        RunInstancesResult runInstancesResult2 = response = runInstancesResult;
        Intrinsics.checkExpressionValueIsNotNull((Object)runInstancesResult2, (String)"response");
        Reservation reservation = runInstancesResult2.getReservation();
        Intrinsics.checkExpressionValueIsNotNull((Object)reservation, (String)"response\n            .reservation");
        List list = reservation.getInstances();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"response\n            .re\u2026on\n            .instances");
        Instance instance = (Instance)CollectionsKt.single((List)list);
        DescribeInstancesRequest describeInstancesRequest = new DescribeInstancesRequest();
        String[] stringArray = new String[1];
        Instance instance2 = instance;
        Intrinsics.checkExpressionValueIsNotNull((Object)instance2, (String)"instance");
        stringArray[0] = instance2.getInstanceId();
        DescribeInstancesRequest describeInstancesRequest2 = describeInstancesRequest.withInstanceIds(stringArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)describeInstancesRequest2, (String)"DescribeInstancesRequest\u2026eIds(instance.instanceId)");
        return describeInstancesRequest2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SecurityGroup allocateSecurityGroup(@NotNull Investment investment, @NotNull CreateSecurityGroupRequest request) {
        Collection<com.amazonaws.services.ec2.model.Tag> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)investment, (String)"investment");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Iterable iterable = investment.tag();
        TagSpecification tagSpecification = new TagSpecification();
        void var5_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Tag tag = (Tag)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            com.amazonaws.services.ec2.model.Tag tag2 = it.toEc2();
            collection.add(tag2);
        }
        collection = (List)destination$iv$iv;
        TagSpecification tagSpec = tagSpecification.withTags((Collection)collection).withResourceType(ResourceType.SecurityGroup);
        CreateSecurityGroupRequest createSecurityGroupRequest = request.withTagSpecifications(new TagSpecification[]{tagSpec});
        Intrinsics.checkExpressionValueIsNotNull((Object)createSecurityGroupRequest, (String)"request.withTagSpecifications(tagSpec)");
        return this.allocateSecurityGroup(createSecurityGroupRequest);
    }

    private final SecurityGroup allocateSecurityGroup(CreateSecurityGroupRequest request) {
        CreateSecurityGroupResult securityGroup = this.ec2.createSecurityGroup(request);
        DescribeSecurityGroupsRequest describeSecurityGroupsRequest = new DescribeSecurityGroupsRequest();
        String[] stringArray = new String[1];
        CreateSecurityGroupResult createSecurityGroupResult = securityGroup;
        Intrinsics.checkExpressionValueIsNotNull((Object)createSecurityGroupResult, (String)"securityGroup");
        stringArray[0] = createSecurityGroupResult.getGroupId();
        DescribeSecurityGroupsRequest refresh2 = describeSecurityGroupsRequest.withGroupIds(stringArray);
        Duration timeout = Duration.ofSeconds(30L);
        Instant deadline = Instant.now().plus(timeout);
        do {
            try {
                DescribeSecurityGroupsResult describeSecurityGroupsResult = this.ec2.describeSecurityGroups(refresh2);
                Intrinsics.checkExpressionValueIsNotNull((Object)describeSecurityGroupsResult, (String)"ec2\n                    \u2026beSecurityGroups(refresh)");
                List results = describeSecurityGroupsResult.getSecurityGroups();
                if (results.size() == 1) {
                    List list = results;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"results");
                    Object object = CollectionsKt.single((List)list);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"results.single()");
                    return (SecurityGroup)object;
                }
            }
            catch (Exception e) {
                this.logger.debug("Failed to find security group " + refresh2, (Throwable)e);
            }
            Thread.sleep(Duration.ofSeconds(5L).toMillis());
        } while (Instant.now().isBefore(deadline));
        throw (Throwable)new Exception("Failed to find with " + refresh2 + " within " + timeout);
    }

    public AwaitingEc2(@NotNull AmazonEC2 ec2, @NotNull TerminationBatchingEc2 terminationBatchingEc22, @NotNull InstanceNanny instanceNanny, @NotNull String defaultAmi2) {
        Intrinsics.checkParameterIsNotNull((Object)ec2, (String)"ec2");
        Intrinsics.checkParameterIsNotNull((Object)terminationBatchingEc22, (String)"terminationBatchingEc2");
        Intrinsics.checkParameterIsNotNull((Object)instanceNanny, (String)"instanceNanny");
        Intrinsics.checkParameterIsNotNull((Object)defaultAmi2, (String)"defaultAmi");
        this.ec2 = ec2;
        this.terminationBatchingEc2 = terminationBatchingEc22;
        this.instanceNanny = instanceNanny;
        this.defaultAmi = defaultAmi2;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }
}

