/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws;

import com.amazonaws.services.ec2.model.Instance;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.Resource;
import com.atlassian.performance.tools.aws.api.Tag;
import com.atlassian.performance.tools.aws.api.TerminationBatchingEc2;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/performance/tools/aws/Ec2Instance;", "Lcom/atlassian/performance/tools/aws/api/Resource;", "instance", "Lcom/amazonaws/services/ec2/model/Instance;", "terminationBatchingEc2", "Lcom/atlassian/performance/tools/aws/api/TerminationBatchingEc2;", "(Lcom/amazonaws/services/ec2/model/Instance;Lcom/atlassian/performance/tools/aws/api/TerminationBatchingEc2;)V", "expiry", "Ljava/time/Instant;", "isExpired", "", "release", "Ljava/util/concurrent/CompletableFuture;", "toString", "", "aws-resources"})
public final class Ec2Instance
implements Resource {
    private final Instant expiry;
    private final Instance instance;
    private final TerminationBatchingEc2 terminationBatchingEc2;

    @Override
    public boolean isExpired() {
        Instant instant = this.expiry;
        return instant != null ? instant.isBefore(Instant.now()) : false;
    }

    @Override
    @NotNull
    public CompletableFuture<?> release() {
        String string = this.instance.getInstanceId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"instance.instanceId");
        return this.terminationBatchingEc2.terminate(string);
    }

    @NotNull
    public String toString() {
        return "Ec2Instance(instanceId = " + this.instance.getInstanceId() + ')';
    }

    /*
     * WARNING - void declaration
     */
    public Ec2Instance(@NotNull Instance instance, @NotNull TerminationBatchingEc2 terminationBatchingEc22) {
        Collection<Tag> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        Intrinsics.checkParameterIsNotNull((Object)terminationBatchingEc22, (String)"terminationBatchingEc2");
        this.instance = instance;
        this.terminationBatchingEc2 = terminationBatchingEc22;
        List list = this.instance.getTags();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"instance.tags");
        Iterable iterable = list;
        Investment.TagKeys tagKeys = Investment.TagKeys;
        Ec2Instance ec2Instance = this;
        void var4_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            com.amazonaws.services.ec2.model.Tag tag = (com.amazonaws.services.ec2.model.Tag)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            Tag tag2 = new Tag((com.amazonaws.services.ec2.model.Tag)v1);
            collection.add(tag2);
        }
        collection = (List)destination$iv$iv;
        ec2Instance.expiry = tagKeys.parseExpiry((List<Tag>)collection);
    }
}

