/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.storage;

import com.atlassian.performance.tools.awsinfrastructure.api.aws.AwsCli;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.net.URI;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/storage/S3Artifact;", "", "region", "", "bucketName", "archivesLocation", "archiveName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getArchiveName", "()Ljava/lang/String;", "uri", "Ljava/net/URI;", "kotlin.jvm.PlatformType", "download", "Lcom/atlassian/performance/tools/ssh/api/SshConnection$SshResult;", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "target", "toString", "aws-infrastructure"})
public final class S3Artifact {
    private final URI uri;
    private final String region;
    @NotNull
    private final String archiveName;

    @NotNull
    public final SshConnection.SshResult download(@NotNull SshConnection ssh, @NotNull String target) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        new AwsCli().ensureAwsCli(ssh);
        String string = "aws s3 cp --only-show-errors --region=" + this.region + ' ' + this.uri + ' ' + target;
        Duration duration = Duration.ofMinutes(2L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(2)");
        return ssh.safeExecute(string, duration);
    }

    @NotNull
    public String toString() {
        return "S3Artifact(region='" + this.region + "', uri=" + this.uri + ')';
    }

    @NotNull
    public final String getArchiveName() {
        return this.archiveName;
    }

    public S3Artifact(@NotNull String region, @NotNull String bucketName, @NotNull String archivesLocation, @NotNull String archiveName) {
        Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
        Intrinsics.checkParameterIsNotNull((Object)bucketName, (String)"bucketName");
        Intrinsics.checkParameterIsNotNull((Object)archivesLocation, (String)"archivesLocation");
        Intrinsics.checkParameterIsNotNull((Object)archiveName, (String)"archiveName");
        this.region = region;
        this.archiveName = archiveName;
        this.uri = URI.create("s3://" + bucketName + '/' + archivesLocation + '/' + this.archiveName);
    }
}

