/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.jira;

import com.atlassian.performance.tools.aws.api.Storage;
import com.atlassian.performance.tools.aws.api.StorageLocation;
import com.atlassian.performance.tools.awsinfrastructure.api.aws.AwsCli;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraGcLog;
import com.atlassian.performance.tools.infrastructure.api.process.RemoteMonitoringProcess;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/StartedNode;", "", "name", "", "jiraHome", "analyticLogs", "resultsTransport", "Lcom/atlassian/performance/tools/aws/api/Storage;", "unpackedProduct", "monitoringProcesses", "", "Lcom/atlassian/performance/tools/infrastructure/api/process/RemoteMonitoringProcess;", "ssh", "Lcom/atlassian/performance/tools/ssh/api/Ssh;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/atlassian/performance/tools/aws/api/Storage;Ljava/lang/String;Ljava/util/List;Lcom/atlassian/performance/tools/ssh/api/Ssh;)V", "resultsDirectory", "copy", "copy$aws_infrastructure", "gatherAnalyticLogs", "", "gatherResults", "toString", "aws-infrastructure"})
public final class StartedNode {
    private final String resultsDirectory = "results";
    private final String name;
    private final String jiraHome;
    private final String analyticLogs;
    private final Storage resultsTransport;
    private final String unpackedProduct;
    private final List<RemoteMonitoringProcess> monitoringProcesses;
    private final Ssh ssh;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void gatherResults() {
        Closeable closeable = (Closeable)this.ssh.newConnection();
        Throwable throwable = null;
        try {
            Collection<String> collection;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            RemoteMonitoringProcess it;
            Object element$iv2;
            SshConnection shell = (SshConnection)closeable;
            Iterable $receiver$iv2 = this.monitoringProcesses;
            for (Object element$iv2 : $receiver$iv2) {
                it = (RemoteMonitoringProcess)element$iv2;
                it.stop(shell);
            }
            String nodeResultsDirectory = this.resultsDirectory + "/'" + this.name + '\'';
            String threadDumpsFolder = "thread-dumps";
            element$iv2 = this.monitoringProcesses;
            Collection collection2 = CollectionsKt.listOf((Object[])new String[]{"mkdir -p " + nodeResultsDirectory, "cp " + this.unpackedProduct + "/logs/catalina.out " + nodeResultsDirectory, "cp " + this.unpackedProduct + "/logs/*access* " + nodeResultsDirectory, "mkdir -p " + nodeResultsDirectory + '/' + threadDumpsFolder, "cp " + threadDumpsFolder + "/* " + nodeResultsDirectory + '/' + threadDumpsFolder, "cp " + this.jiraHome + "/log/atlassian-jira.log " + nodeResultsDirectory, "cp " + JiraGcLog.path$default((JiraGcLog)new JiraGcLog(this.unpackedProduct), null, (int)1, null) + ' ' + nodeResultsDirectory, "cp /var/log/syslog " + nodeResultsDirectory, "cp /var/log/cloud-init.log " + nodeResultsDirectory, "cp /var/log/cloud-init-output.log " + nodeResultsDirectory});
            it = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it2;
                RemoteMonitoringProcess remoteMonitoringProcess = (RemoteMonitoringProcess)item$iv$iv;
                collection = destination$iv$iv;
                String string = "cp " + it2.getResultPath() + ' ' + nodeResultsDirectory;
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            $receiver$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection2, (Iterable)collection), (Object)("find " + nodeResultsDirectory + " -empty -type f -delete"));
            for (Object element$iv3 : $receiver$iv) {
                String it3 = (String)element$iv3;
                shell.safeExecute(it3);
            }
            AwsCli awsCli = new AwsCli();
            StorageLocation storageLocation = this.resultsTransport.getLocation();
            Duration duration = Duration.ofMinutes(10L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(10)");
            awsCli.upload(storageLocation, shell, this.resultsDirectory, duration);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void gatherAnalyticLogs() {
        Closeable closeable = (Closeable)this.ssh.newConnection();
        Throwable throwable = null;
        try {
            SshConnection it = (SshConnection)closeable;
            it.execute("cp -r " + this.analyticLogs + "/analytics-logs " + this.resultsDirectory);
            it.execute("find " + this.resultsDirectory + "/analytics-logs/ -maxdepth 1 -type f -name '*.gz' -exec gunzip {} +");
            AwsCli awsCli = new AwsCli();
            StorageLocation storageLocation = this.resultsTransport.getLocation();
            Duration duration = Duration.ofMinutes(2L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(2)");
            awsCli.upload(storageLocation, it, this.resultsDirectory, duration);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final StartedNode copy$aws_infrastructure(@NotNull String name, @NotNull String analyticLogs) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)analyticLogs, (String)"analyticLogs");
        return new StartedNode(name, this.jiraHome, analyticLogs, this.resultsTransport, this.unpackedProduct, this.monitoringProcesses, this.ssh);
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    public StartedNode(@NotNull String name, @NotNull String jiraHome, @NotNull String analyticLogs, @NotNull Storage resultsTransport, @NotNull String unpackedProduct, @NotNull List<? extends RemoteMonitoringProcess> monitoringProcesses, @NotNull Ssh ssh) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)jiraHome, (String)"jiraHome");
        Intrinsics.checkParameterIsNotNull((Object)analyticLogs, (String)"analyticLogs");
        Intrinsics.checkParameterIsNotNull((Object)resultsTransport, (String)"resultsTransport");
        Intrinsics.checkParameterIsNotNull((Object)unpackedProduct, (String)"unpackedProduct");
        Intrinsics.checkParameterIsNotNull(monitoringProcesses, (String)"monitoringProcesses");
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        this.name = name;
        this.jiraHome = jiraHome;
        this.analyticLogs = analyticLogs;
        this.resultsTransport = resultsTransport;
        this.unpackedProduct = unpackedProduct;
        this.monitoringProcesses = monitoringProcesses;
        this.ssh = ssh;
        this.resultsDirectory = "results";
    }
}

