/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api;

import com.atlassian.performance.tools.aws.api.SshKey;
import com.atlassian.performance.tools.aws.api.Storage;
import com.atlassian.performance.tools.awsinfrastructure.api.InfrastructureKt;
import com.atlassian.performance.tools.awsinfrastructure.api.LegacyTargetingVirtualUserOptions;
import com.atlassian.performance.tools.awsinfrastructure.api.TargetingVirtualUserOptions;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.Jira;
import com.atlassian.performance.tools.concurrency.api.TaskContextKt;
import com.atlassian.performance.tools.infrastructure.api.MeasurementSource;
import com.atlassian.performance.tools.infrastructure.api.virtualusers.VirtualUsers;
import com.atlassian.performance.tools.jvmtasks.api.TaskTimer;
import com.atlassian.performance.tools.virtualusers.api.config.VirtualUserBehavior;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/Infrastructure;", "T", "Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/VirtualUsers;", "", "virtualUsers", "jira", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/Jira;", "resultsTransport", "Lcom/atlassian/performance/tools/aws/api/Storage;", "sshKey", "Lcom/atlassian/performance/tools/aws/api/SshKey;", "(Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/VirtualUsers;Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/Jira;Lcom/atlassian/performance/tools/aws/api/Storage;Lcom/atlassian/performance/tools/aws/api/SshKey;)V", "getJira", "()Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/Jira;", "logger", "Lorg/apache/logging/log4j/Logger;", "getSshKey", "()Lcom/atlassian/performance/tools/aws/api/SshKey;", "getVirtualUsers", "()Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/VirtualUsers;", "Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/VirtualUsers;", "applyLoad", "", "options", "Lcom/atlassian/performance/tools/awsinfrastructure/api/TargetingVirtualUserOptions;", "behavior", "Lcom/atlassian/performance/tools/virtualusers/api/config/VirtualUserBehavior;", "downloadResults", "Ljava/nio/file/Path;", "target", "toString", "", "aws-infrastructure"})
public final class Infrastructure<T extends VirtualUsers> {
    private final Logger logger;
    @NotNull
    private final T virtualUsers;
    @NotNull
    private final Jira jira;
    private final Storage resultsTransport;
    @NotNull
    private final SshKey sshKey;

    public final void applyLoad(@NotNull TargetingVirtualUserOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        TaskTimer.INSTANCE.time("applying load", (Function0)new Function0<Unit>(this, options){
            final /* synthetic */ Infrastructure this$0;
            final /* synthetic */ TargetingVirtualUserOptions $options;

            public final void invoke() {
                this.this$0.getVirtualUsers().applyLoad(this.$options.target(this.this$0.getJira().getAddress()));
            }
            {
                this.this$0 = infrastructure;
                this.$options = targetingVirtualUserOptions;
                super(0);
            }
        });
    }

    @Deprecated(message="Use applyLoad(TargetingVirtualUserOptions)", replaceWith=@ReplaceWith(imports={"com.atlassian.performance.tools.awsinfrastructure.api.LegacyTargetingVirtualUserOptions"}, expression="applyLoad(LegacyTargetingVirtualUserOptions(behavior))"))
    public final void applyLoad(@NotNull VirtualUserBehavior behavior) {
        Intrinsics.checkParameterIsNotNull((Object)behavior, (String)"behavior");
        this.applyLoad(new LegacyTargetingVirtualUserOptions(behavior));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path downloadResults(@NotNull Path target) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.logger.info("Downloading results...");
        List resultSources = CollectionsKt.listOf((Object[])new MeasurementSource[]{(MeasurementSource)this.virtualUsers, this.jira});
        ExecutorService executor = Executors.newFixedThreadPool(InfrastructureKt.access$butNotMoreThan(resultSources.size(), 4), new ThreadFactoryBuilder().setNameFormat("gather-results-thread-%d").build());
        Iterable iterable = resultSources;
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            MeasurementSource measurementSource = (MeasurementSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            ExecutorService executorService = executor;
            Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"executor");
            CompletableFuture completableFuture = TaskContextKt.submitWithLogContext((ExecutorService)executorService, (String)"results", (Function0)((Function0)new Function0<Unit>((MeasurementSource)it){
                final /* synthetic */ MeasurementSource $it;

                public final void invoke() {
                    this.$it.gatherResults();
                }
                {
                    this.$it = measurementSource;
                    super(0);
                }
            }));
            collection.add(completableFuture);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            CompletableFuture it = (CompletableFuture)element$iv;
            try {
                it.get();
            }
            catch (Exception e) {
                this.logger.error("Failed to gather results. Proceeding...", (Throwable)e);
            }
        }
        executor.shutdownNow();
        this.logger.debug("Results are gathered");
        Path results = this.resultsTransport.download(target);
        this.logger.info("Results are downloaded");
        return results;
    }

    @NotNull
    public String toString() {
        return "Infrastructure(virtualUsers=" + this.virtualUsers + ", jira=" + this.jira + ", resultsTransport=" + this.resultsTransport + ", sshKey=" + this.sshKey + ')';
    }

    @NotNull
    public final T getVirtualUsers() {
        return this.virtualUsers;
    }

    @NotNull
    public final Jira getJira() {
        return this.jira;
    }

    @NotNull
    public final SshKey getSshKey() {
        return this.sshKey;
    }

    public Infrastructure(@NotNull T virtualUsers, @NotNull Jira jira, @NotNull Storage resultsTransport, @NotNull SshKey sshKey) {
        Intrinsics.checkParameterIsNotNull(virtualUsers, (String)"virtualUsers");
        Intrinsics.checkParameterIsNotNull((Object)jira, (String)"jira");
        Intrinsics.checkParameterIsNotNull((Object)resultsTransport, (String)"resultsTransport");
        Intrinsics.checkParameterIsNotNull((Object)sshKey, (String)"sshKey");
        this.virtualUsers = virtualUsers;
        this.jira = jira;
        this.resultsTransport = resultsTransport;
        this.sshKey = sshKey;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }
}

