/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api;

import com.atlassian.performance.tools.aws.api.StorageLocation;
import com.atlassian.performance.tools.awsinfrastructure.api.DatasetCatalogue;
import com.atlassian.performance.tools.awsinfrastructure.api.RemoteLocation;
import com.atlassian.performance.tools.concurrency.api.TaskContextKt;
import com.atlassian.performance.tools.infrastructure.api.dataset.Dataset;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import com.atlassian.performance.tools.ssh.api.SshHost;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003 !\"B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001d\u001a\u00020\u0007J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource;", "", "jiraHome", "Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;", "database", "(Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;)V", "json", "Ljavax/json/JsonObject;", "(Ljavax/json/JsonObject;)V", "jiraHomeTimeouts", "Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource$Timeouts;", "databaseTimeouts", "(Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource$Timeouts;Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource$Timeouts;)V", "getDatabase", "()Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;", "getJiraHome", "logger", "Lorg/apache/logging/log4j/Logger;", "stopDockerContainers", "", "host", "Lcom/atlassian/performance/tools/ssh/api/SshHost;", "stopJira", "store", "Lcom/atlassian/performance/tools/infrastructure/api/dataset/Dataset;", "location", "Lcom/atlassian/performance/tools/aws/api/StorageLocation;", "store$aws_infrastructure", "storeInS3", "toJson", "toString", "", "Builder", "FileNames", "Timeouts", "aws-infrastructure"})
public final class CustomDatasetSource {
    private final Logger logger;
    @NotNull
    private final RemoteLocation jiraHome;
    @NotNull
    private final RemoteLocation database;
    private final Timeouts jiraHomeTimeouts;
    private final Timeouts databaseTimeouts;

    @NotNull
    public final JsonObject toJson() {
        JsonObject jsonObject = Json.createObjectBuilder().add("jiraHome", (JsonValue)this.jiraHome.toJson()).add("database", (JsonValue)this.database.toJson()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"Json.createObjectBuilder\u2026n())\n            .build()");
        return jsonObject;
    }

    public final void storeInS3(@NotNull StorageLocation location) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        this.store$aws_infrastructure(location);
    }

    @NotNull
    public final Dataset store$aws_infrastructure(@NotNull StorageLocation location) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        this.logger.info("Uploading dataset to '" + location + "'...");
        ExecutorService executor = Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().setNameFormat("s3-upload-thread-%d").build());
        this.stopJira(this.jiraHome.getHost());
        this.stopDockerContainers(this.database.getHost());
        ExecutorService executorService = executor;
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"executor");
        CompletableFuture jiraHomeUpload2 = TaskContextKt.submitWithLogContext((ExecutorService)executorService, (String)"jiraHome", (Function0)((Function0)new Function0<Unit>(this, location){
            final /* synthetic */ CustomDatasetSource this$0;
            final /* synthetic */ StorageLocation $location;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                RemoteLocation remoteLocation = this.this$0.getJiraHome();
                Duration duration = Duration.ofMinutes(1L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(1)");
                RemoteLocation renamed = remoteLocation.move("jirahome", duration);
                try {
                    renamed.archive(CustomDatasetSource.access$getJiraHomeTimeouts$p(this.this$0).getArchive()).upload(this.$location, CustomDatasetSource.access$getJiraHomeTimeouts$p(this.this$0).getUpload());
                }
                finally {
                    renamed.move(this.this$0.getJiraHome().getLocation(), CustomDatasetSource.access$getJiraHomeTimeouts$p(this.this$0).getMove());
                }
            }
            {
                this.this$0 = customDatasetSource;
                this.$location = storageLocation;
                super(0);
            }
        }));
        CompletableFuture databaseUpload2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"database", (Function0)((Function0)new Function0<Unit>(this, location){
            final /* synthetic */ CustomDatasetSource this$0;
            final /* synthetic */ StorageLocation $location;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                RemoteLocation remoteLocation = this.this$0.getDatabase();
                Duration duration = Duration.ofMinutes(1L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(1)");
                RemoteLocation renamed = remoteLocation.move("database", duration);
                try {
                    renamed.archive(CustomDatasetSource.access$getDatabaseTimeouts$p(this.this$0).getArchive()).upload(this.$location, CustomDatasetSource.access$getDatabaseTimeouts$p(this.this$0).getUpload());
                }
                finally {
                    renamed.move(this.this$0.getDatabase().getLocation(), CustomDatasetSource.access$getDatabaseTimeouts$p(this.this$0).getMove());
                }
            }
            {
                this.this$0 = customDatasetSource;
                this.$location = storageLocation;
                super(0);
            }
        }));
        jiraHomeUpload2.get();
        databaseUpload2.get();
        executor.shutdownNow();
        String locationSnippet = location.toKotlinCodeSnippet();
        this.logger.info("Dataset saved. You can use it via `DatasetCatalogue().custom(" + locationSnippet + ")`");
        return DatasetCatalogue.custom$default(new DatasetCatalogue(), location, null, null, null, 14, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopJira(SshHost host2) {
        String shutdownTomcat = "echo SHUTDOWN | nc localhost 8005";
        String waitForNoJavaProcess = "while ps -C java -o pid=; do sleep 5; done";
        Closeable closeable = (Closeable)new Ssh(host2, 4).newConnection();
        Throwable throwable = null;
        try {
            SshConnection it = (SshConnection)closeable;
            String string = shutdownTomcat + " && " + waitForNoJavaProcess;
            Duration duration = Duration.ofMinutes(3L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(3)");
            SshConnection.SshResult sshResult = it.safeExecute(string, duration);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopDockerContainers(SshHost host2) {
        Closeable closeable = (Closeable)new Ssh(host2, 4).newConnection();
        Throwable throwable = null;
        try {
            SshConnection it = (SshConnection)closeable;
            SshConnection.SshResult sshResult = it.safeExecute("docker stop $(docker ps -aq)");
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public String toString() {
        return "CustomDatasetSource(jiraHome=" + this.jiraHome + ", database=" + this.database + ')';
    }

    @NotNull
    public final RemoteLocation getJiraHome() {
        return this.jiraHome;
    }

    @NotNull
    public final RemoteLocation getDatabase() {
        return this.database;
    }

    private CustomDatasetSource(RemoteLocation jiraHome, RemoteLocation database, Timeouts jiraHomeTimeouts, Timeouts databaseTimeouts) {
        this.jiraHome = jiraHome;
        this.database = database;
        this.jiraHomeTimeouts = jiraHomeTimeouts;
        this.databaseTimeouts = databaseTimeouts;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    @Deprecated(message="Use Builder.CustomDatasetSource instead")
    public CustomDatasetSource(@NotNull RemoteLocation jiraHome, @NotNull RemoteLocation database) {
        Intrinsics.checkParameterIsNotNull((Object)jiraHome, (String)"jiraHome");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Duration duration = Duration.ofMinutes(25L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(25)");
        Duration duration2 = Duration.ofMinutes(10L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMinutes(10)");
        Duration duration3 = Duration.ofMinutes(1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ofMinutes(1)");
        Timeouts timeouts = new Timeouts(duration, duration2, duration3);
        Duration duration4 = Duration.ofMinutes(25L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration4, (String)"Duration.ofMinutes(25)");
        Duration duration5 = Duration.ofMinutes(10L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration5, (String)"Duration.ofMinutes(10)");
        Duration duration6 = Duration.ofMinutes(1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration6, (String)"Duration.ofMinutes(1)");
        this(jiraHome, database, timeouts, new Timeouts(duration4, duration5, duration6));
    }

    @Deprecated(message="Use Use Builder.CustomDatasetSource.fromJson instead")
    public CustomDatasetSource(@NotNull JsonObject json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        JsonObject jsonObject = json.getJsonObject("jiraHome");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"json.getJsonObject(\"jiraHome\")");
        RemoteLocation remoteLocation = new RemoteLocation(jsonObject);
        JsonObject jsonObject2 = json.getJsonObject("database");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject2, (String)"json.getJsonObject(\"database\")");
        this(remoteLocation, new RemoteLocation(jsonObject2));
    }

    public /* synthetic */ CustomDatasetSource(@NotNull RemoteLocation jiraHome, @NotNull RemoteLocation database, @NotNull Timeouts jiraHomeTimeouts, @NotNull Timeouts databaseTimeouts, DefaultConstructorMarker $constructor_marker) {
        this(jiraHome, database, jiraHomeTimeouts, databaseTimeouts);
    }

    @NotNull
    public static final /* synthetic */ Timeouts access$getJiraHomeTimeouts$p(CustomDatasetSource $this) {
        return $this.jiraHomeTimeouts;
    }

    @NotNull
    public static final /* synthetic */ Timeouts access$getDatabaseTimeouts$p(CustomDatasetSource $this) {
        return $this.databaseTimeouts;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource$FileNames;", "", "()V", "DATABASE", "", "JIRAHOME", "aws-infrastructure"})
    public static final class FileNames {
        @NotNull
        public static final String DATABASE = "database";
        @NotNull
        public static final String JIRAHOME = "jirahome";
        public static final FileNames INSTANCE;

        private FileNames() {
        }

        static {
            FileNames fileNames;
            INSTANCE = fileNames = new FileNames();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource$Timeouts;", "", "archive", "Ljava/time/Duration;", "upload", "move", "(Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;)V", "getArchive", "()Ljava/time/Duration;", "getMove", "getUpload", "aws-infrastructure"})
    private static final class Timeouts {
        @NotNull
        private final Duration archive;
        @NotNull
        private final Duration upload;
        @NotNull
        private final Duration move;

        @NotNull
        public final Duration getArchive() {
            return this.archive;
        }

        @NotNull
        public final Duration getUpload() {
            return this.upload;
        }

        @NotNull
        public final Duration getMove() {
            return this.move;
        }

        public Timeouts(@NotNull Duration archive, @NotNull Duration upload, @NotNull Duration move) {
            Intrinsics.checkParameterIsNotNull((Object)archive, (String)"archive");
            Intrinsics.checkParameterIsNotNull((Object)upload, (String)"upload");
            Intrinsics.checkParameterIsNotNull((Object)move, (String)"move");
            this.archive = archive;
            this.upload = upload;
            this.move = move;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\nR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource$Builder;", "", "json", "Ljavax/json/JsonObject;", "(Ljavax/json/JsonObject;)V", "jiraHome", "Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;", "database", "(Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;)V", "databaseArchiveTimeout", "Ljava/time/Duration;", "databaseMoveTimeout", "databaseUploadTimeout", "jiraHomeArchiveTimeout", "jiraHomeMoveTimeout", "jiraHomeUploadTimeout", "build", "Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource;", "aws-infrastructure"})
    public static final class Builder {
        private Duration jiraHomeArchiveTimeout;
        private Duration jiraHomeUploadTimeout;
        private Duration jiraHomeMoveTimeout;
        private Duration databaseArchiveTimeout;
        private Duration databaseUploadTimeout;
        private Duration databaseMoveTimeout;
        private RemoteLocation jiraHome;
        private RemoteLocation database;

        @NotNull
        public final Builder jiraHome(@NotNull RemoteLocation jiraHome) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jiraHome, (String)"jiraHome");
            Builder $receiver = builder = this;
            $receiver.jiraHome = jiraHome;
            return builder;
        }

        @NotNull
        public final Builder database(@NotNull RemoteLocation database) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            Builder $receiver = builder = this;
            $receiver.database = database;
            return builder;
        }

        @NotNull
        public final Builder jiraHomeArchiveTimeout(@NotNull Duration jiraHomeArchiveTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jiraHomeArchiveTimeout, (String)"jiraHomeArchiveTimeout");
            Builder $receiver = builder = this;
            $receiver.jiraHomeArchiveTimeout = jiraHomeArchiveTimeout;
            return builder;
        }

        @NotNull
        public final Builder jiraHomeUploadTimeout(@NotNull Duration jiraHomeUploadTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jiraHomeUploadTimeout, (String)"jiraHomeUploadTimeout");
            Builder $receiver = builder = this;
            $receiver.jiraHomeUploadTimeout = jiraHomeUploadTimeout;
            return builder;
        }

        @NotNull
        public final Builder jiraHomeMoveTimeout(@NotNull Duration jiraHomeMoveTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jiraHomeMoveTimeout, (String)"jiraHomeMoveTimeout");
            Builder $receiver = builder = this;
            $receiver.jiraHomeMoveTimeout = jiraHomeMoveTimeout;
            return builder;
        }

        @NotNull
        public final Builder databaseArchiveTimeout(@NotNull Duration databaseArchiveTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)databaseArchiveTimeout, (String)"databaseArchiveTimeout");
            Builder $receiver = builder = this;
            $receiver.databaseArchiveTimeout = databaseArchiveTimeout;
            return builder;
        }

        @NotNull
        public final Builder databaseUploadTimeout(@NotNull Duration databaseUploadTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)databaseUploadTimeout, (String)"databaseUploadTimeout");
            Builder $receiver = builder = this;
            $receiver.databaseUploadTimeout = databaseUploadTimeout;
            return builder;
        }

        @NotNull
        public final Builder databaseMoveTimeout(@NotNull Duration databaseMoveTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)databaseMoveTimeout, (String)"databaseMoveTimeout");
            Builder $receiver = builder = this;
            $receiver.databaseMoveTimeout = databaseMoveTimeout;
            return builder;
        }

        @NotNull
        public final CustomDatasetSource build() {
            return new CustomDatasetSource(this.jiraHome, this.database, new Timeouts(this.jiraHomeArchiveTimeout, this.jiraHomeUploadTimeout, this.jiraHomeMoveTimeout), new Timeouts(this.databaseArchiveTimeout, this.databaseUploadTimeout, this.databaseMoveTimeout), null);
        }

        public Builder(@NotNull RemoteLocation jiraHome, @NotNull RemoteLocation database) {
            Intrinsics.checkParameterIsNotNull((Object)jiraHome, (String)"jiraHome");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            this.jiraHome = jiraHome;
            this.database = database;
            Duration duration = Duration.ofMinutes(25L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(25)");
            this.jiraHomeArchiveTimeout = duration;
            Duration duration2 = Duration.ofMinutes(10L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMinutes(10)");
            this.jiraHomeUploadTimeout = duration2;
            Duration duration3 = Duration.ofMinutes(1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ofMinutes(1)");
            this.jiraHomeMoveTimeout = duration3;
            Duration duration4 = Duration.ofMinutes(25L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration4, (String)"Duration.ofMinutes(25)");
            this.databaseArchiveTimeout = duration4;
            Duration duration5 = Duration.ofMinutes(10L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration5, (String)"Duration.ofMinutes(10)");
            this.databaseUploadTimeout = duration5;
            Duration duration6 = Duration.ofMinutes(1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration6, (String)"Duration.ofMinutes(1)");
            this.databaseMoveTimeout = duration6;
        }

        public Builder(@NotNull JsonObject json) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            JsonObject jsonObject = json.getJsonObject("jiraHome");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"json.getJsonObject(\"jiraHome\")");
            RemoteLocation remoteLocation = new RemoteLocation(jsonObject);
            JsonObject jsonObject2 = json.getJsonObject("database");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject2, (String)"json.getJsonObject(\"database\")");
            this(remoteLocation, new RemoteLocation(jsonObject2));
        }
    }
}

