/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api;

import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.Resource;
import com.atlassian.performance.tools.awsinfrastructure.api.AwsDatasetModification;
import com.atlassian.performance.tools.awsinfrastructure.api.CustomDatasetSource;
import com.atlassian.performance.tools.awsinfrastructure.api.Infrastructure;
import com.atlassian.performance.tools.awsinfrastructure.api.InfrastructureFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.ProvisionedInfrastructure;
import com.atlassian.performance.tools.awsinfrastructure.api.RemoteLocation;
import com.atlassian.performance.tools.awsinfrastructure.api.dataset.DatasetHost;
import com.atlassian.performance.tools.awsinfrastructure.api.dataset.SshMysqlDatasetPublication;
import com.atlassian.performance.tools.awsinfrastructure.api.hardware.C5NineExtraLargeEphemeral;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.Jira;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.StandaloneFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.virtualusers.AbsentVirtualUsers;
import com.atlassian.performance.tools.awsinfrastructure.api.virtualusers.AbsentVirtualUsersFormula;
import com.atlassian.performance.tools.infrastructure.api.database.Database;
import com.atlassian.performance.tools.infrastructure.api.dataset.Dataset;
import com.atlassian.performance.tools.infrastructure.api.distribution.ProductDistribution;
import com.atlassian.performance.tools.infrastructure.api.distribution.PublicJiraSoftwareDistribution;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraHomeSource;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import com.atlassian.performance.tools.workspace.api.RootWorkspace;
import com.atlassian.performance.tools.workspace.api.TaskWorkspace;
import com.atlassian.performance.tools.workspace.api.TestWorkspace;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0002\u001f BO\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0014\u0010\u0015\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0006\u0010\u0016\u001a\u00020\u0005J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/AwsDatasetModification;", "", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "dataset", "Lcom/atlassian/performance/tools/infrastructure/api/dataset/Dataset;", "workspace", "Lcom/atlassian/performance/tools/workspace/api/TestWorkspace;", "newDatasetName", "", "host", "Lcom/atlassian/performance/tools/awsinfrastructure/api/dataset/DatasetHost;", "onlineTransformation", "Ljava/util/function/Consumer;", "Lcom/atlassian/performance/tools/awsinfrastructure/api/Infrastructure;", "datasetSourceConfig", "Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource$Builder;", "(Lcom/atlassian/performance/tools/aws/api/Aws;Lcom/atlassian/performance/tools/infrastructure/api/dataset/Dataset;Lcom/atlassian/performance/tools/workspace/api/TestWorkspace;Ljava/lang/String;Lcom/atlassian/performance/tools/awsinfrastructure/api/dataset/DatasetHost;Ljava/util/function/Consumer;Ljava/util/function/Consumer;)V", "apply", "", "infrastructure", "cleanUp", "modify", "persist", "jira", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/Jira;", "provision", "Lcom/atlassian/performance/tools/awsinfrastructure/api/ProvisionedInfrastructure;", "release", "resource", "Lcom/atlassian/performance/tools/aws/api/Resource;", "Builder", "Companion", "aws-infrastructure"})
public final class AwsDatasetModification {
    private final Aws aws;
    private final Dataset dataset;
    private final TestWorkspace workspace;
    private final String newDatasetName;
    private final DatasetHost host;
    private final Consumer<Infrastructure<?>> onlineTransformation;
    private final Consumer<CustomDatasetSource.Builder> datasetSourceConfig;
    private static final Logger logger;
    @java.lang.Deprecated
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Dataset modify() {
        ProvisionedInfrastructure<?> provisionedInfrastructure = this.provision();
        Infrastructure<?> infrastructure = provisionedInfrastructure.getInfrastructure();
        Resource resource = provisionedInfrastructure.getResource();
        try {
            this.apply(infrastructure);
            this.cleanUp(infrastructure);
            Dataset dataset = this.persist(infrastructure.getJira());
            return dataset;
        }
        finally {
            this.release(resource);
        }
    }

    private final ProvisionedInfrastructure<?> provision() {
        logger.info("Provisioning the " + this.dataset.getLabel() + " dataset ...");
        ProvisionedInfrastructure<?> infrastructure = this.host.host(this.dataset).provision(this.workspace.getDirectory());
        logger.info("Provisioned successfully");
        return infrastructure;
    }

    private final void apply(Infrastructure<?> infrastructure) {
        logger.info("Modifying the dataset ...");
        this.onlineTransformation.accept(infrastructure);
        logger.info("Dataset modified");
        String publicationMechanism = SshMysqlDatasetPublication.class.getCanonicalName();
        logger.info("It might contain a license. To publish this dataset, use the " + publicationMechanism);
    }

    private final Dataset persist(Jira jira) {
        CustomDatasetSource.Builder builder;
        logger.info("Persisting the " + this.newDatasetName + " dataset ...");
        RemoteLocation jiraHome = jira.getJiraHome();
        RemoteLocation remoteLocation = jira.getDatabase();
        if (remoteLocation == null) {
            throw (Throwable)new Exception("The database should have been provisioned");
        }
        RemoteLocation database = remoteLocation;
        CustomDatasetSource.Builder it = builder = new CustomDatasetSource.Builder(jiraHome, database);
        this.datasetSourceConfig.accept(it);
        CustomDatasetSource source = builder.build();
        Dataset storedDataset = source.store$aws_infrastructure(this.aws.customDatasetStorage(this.newDatasetName).getLocation());
        logger.info("Dataset " + this.newDatasetName + " persisted");
        return storedDataset;
    }

    private final void release(Resource resource) {
        logger.info("Releasing AWS resources ...");
        resource.release().get(2L, TimeUnit.MINUTES);
        logger.info("AWS resources released");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanUp(Infrastructure<?> infrastructure) {
        RemoteLocation jiraHome = infrastructure.getJira().getJiraHome();
        String jiraHomeDir = jiraHome.getLocation();
        List dirsToPurge = CollectionsKt.listOf((Object[])new String[]{jiraHomeDir + "/analytics-logs/*", jiraHomeDir + "/log/*", jiraHomeDir + "/plugins/*", jiraHomeDir + "/export/*", jiraHomeDir + "/import/*"});
        Closeable closeable = (Closeable)new Ssh(jiraHome.getHost(), 4).newConnection();
        Throwable throwable = null;
        try {
            SshConnection ssh = (SshConnection)closeable;
            Iterable $receiver$iv = dirsToPurge;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                ssh.execute("rm -rf " + it);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private AwsDatasetModification(Aws aws, Dataset dataset, TestWorkspace workspace, String newDatasetName, DatasetHost host2, Consumer<Infrastructure<?>> onlineTransformation2, Consumer<CustomDatasetSource.Builder> datasetSourceConfig2) {
        this.aws = aws;
        this.dataset = dataset;
        this.workspace = workspace;
        this.newDatasetName = newDatasetName;
        this.host = host2;
        this.onlineTransformation = onlineTransformation2;
        this.datasetSourceConfig = datasetSourceConfig2;
    }

    static {
        Companion = new Companion(null);
        logger = LogManager.getLogger(AwsDatasetModification.class);
    }

    public /* synthetic */ AwsDatasetModification(@NotNull Aws aws, @NotNull Dataset dataset, @NotNull TestWorkspace workspace, @NotNull String newDatasetName, @NotNull DatasetHost host2, @NotNull Consumer onlineTransformation2, @NotNull Consumer datasetSourceConfig2, DefaultConstructorMarker $constructor_marker) {
        this(aws, dataset, workspace, newDatasetName, host2, onlineTransformation2, datasetSourceConfig2);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u0014\u0010\u000b\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0014\u0010\u0018\u001a\u00020\u00002\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0007J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00002\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\fJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/AwsDatasetModification$Builder;", "", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "dataset", "Lcom/atlassian/performance/tools/infrastructure/api/dataset/Dataset;", "(Lcom/atlassian/performance/tools/aws/api/Aws;Lcom/atlassian/performance/tools/infrastructure/api/dataset/Dataset;)V", "getDataset$aws_infrastructure", "()Lcom/atlassian/performance/tools/infrastructure/api/dataset/Dataset;", "setDataset$aws_infrastructure", "(Lcom/atlassian/performance/tools/infrastructure/api/dataset/Dataset;)V", "datasetSourceConfig", "Ljava/util/function/Consumer;", "Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource$Builder;", "host", "Lcom/atlassian/performance/tools/awsinfrastructure/api/dataset/DatasetHost;", "newDatasetName", "", "onlineTransformation", "Lcom/atlassian/performance/tools/awsinfrastructure/api/Infrastructure;", "workspace", "Lcom/atlassian/performance/tools/workspace/api/TestWorkspace;", "build", "Lcom/atlassian/performance/tools/awsinfrastructure/api/AwsDatasetModification;", "formula", "Lcom/atlassian/performance/tools/awsinfrastructure/api/InfrastructureFormula;", "aws-infrastructure"})
    public static final class Builder {
        private Consumer<Infrastructure<?>> onlineTransformation;
        private TestWorkspace workspace;
        private String newDatasetName;
        private DatasetHost host;
        private Consumer<CustomDatasetSource.Builder> datasetSourceConfig;
        private final Aws aws;
        @NotNull
        private Dataset dataset;

        @NotNull
        public final Builder dataset(@NotNull Dataset dataset) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)dataset, (String)"dataset");
            Builder $receiver = builder = this;
            $receiver.dataset = dataset;
            return builder;
        }

        @NotNull
        public final Builder host(@NotNull DatasetHost host2) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)host2, (String)"host");
            Builder $receiver = builder = this;
            $receiver.host = host2;
            return builder;
        }

        @NotNull
        public final Builder onlineTransformation(@NotNull Consumer<Infrastructure<?>> onlineTransformation2) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(onlineTransformation2, (String)"onlineTransformation");
            Builder $receiver = builder = this;
            $receiver.onlineTransformation = onlineTransformation2;
            return builder;
        }

        @NotNull
        public final Builder workspace(@NotNull TestWorkspace workspace) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)workspace, (String)"workspace");
            Builder $receiver = builder = this;
            $receiver.workspace = workspace;
            return builder;
        }

        @NotNull
        public final Builder newDatasetName(@NotNull String newDatasetName) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)newDatasetName, (String)"newDatasetName");
            Builder $receiver = builder = this;
            $receiver.newDatasetName = newDatasetName;
            return builder;
        }

        @NotNull
        public final Builder datasetSourceConfig(@NotNull Consumer<CustomDatasetSource.Builder> datasetSourceConfig2) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(datasetSourceConfig2, (String)"datasetSourceConfig");
            Builder $receiver = builder = this;
            $receiver.datasetSourceConfig = datasetSourceConfig2;
            return builder;
        }

        @Deprecated(message="This ignores `dataset` building. Replace with `host` or `dataset`.")
        @NotNull
        public final Builder formula(@NotNull InfrastructureFormula<?> formula) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(formula, (String)"formula");
            Builder $receiver = builder = this;
            $receiver.host = new DatasetHost(formula){
                final /* synthetic */ InfrastructureFormula $formula$inlined;
                {
                    this.$formula$inlined = infrastructureFormula;
                }

                @NotNull
                public final InfrastructureFormula<?> host(Dataset it) {
                    return this.$formula$inlined;
                }
            };
            return builder;
        }

        @NotNull
        public final AwsDatasetModification build() {
            return new AwsDatasetModification(this.aws, this.dataset, this.workspace, this.newDatasetName, this.host, this.onlineTransformation, this.datasetSourceConfig, null);
        }

        @NotNull
        public final Dataset getDataset$aws_infrastructure() {
            return this.dataset;
        }

        public final void setDataset$aws_infrastructure(@NotNull Dataset dataset) {
            Intrinsics.checkParameterIsNotNull((Object)dataset, (String)"<set-?>");
            this.dataset = dataset;
        }

        public Builder(@NotNull Aws aws, @NotNull Dataset dataset) {
            Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
            Intrinsics.checkParameterIsNotNull((Object)dataset, (String)"dataset");
            this.aws = aws;
            this.dataset = dataset;
            this.onlineTransformation = onlineTransformation.1.INSTANCE;
            TaskWorkspace taskWorkspace = new RootWorkspace(null, 1, null).getCurrentTask();
            String string = this.getClass().getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
            this.workspace = taskWorkspace.isolateTest(string);
            this.newDatasetName = "dataset-" + UUID.randomUUID();
            this.host = new DatasetHost(this){
                final /* synthetic */ Builder this$0;

                @NotNull
                public final InfrastructureFormula<AbsentVirtualUsers> host(Dataset it) {
                    InfrastructureFormula.Builder<T> builder = new InfrastructureFormula.Builder<T>(Builder.access$getAws$p(this.this$0), new AbsentVirtualUsersFormula());
                    Duration duration = Duration.ofMinutes(50L);
                    Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(50)");
                    ProductDistribution productDistribution = (ProductDistribution)new PublicJiraSoftwareDistribution("7.2.0");
                    JiraHomeSource jiraHomeSource = it.getJiraHomeSource();
                    Database database = it.getDatabase();
                    return builder.investment(new Investment("Generic purpose dataset modification", duration, false, null, 12, null)).jiraFormula(new StandaloneFormula.Builder(productDistribution, jiraHomeSource, database).computer(new C5NineExtraLargeEphemeral()).build()).build();
                }
                {
                    this.this$0 = builder;
                }
            };
            this.datasetSourceConfig = datasetSourceConfig.1.INSTANCE;
        }

        @NotNull
        public static final /* synthetic */ Aws access$getAws$p(Builder $this) {
            return $this.aws;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/AwsDatasetModification$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "aws-infrastructure"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

