/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure;

import com.atlassian.performance.tools.awsinfrastructure.api.storage.ApplicationStorage;
import com.atlassian.performance.tools.infrastructure.api.distribution.ProductDistribution;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/ApplicationStorageWrapper;", "Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "applicationStorage", "Lcom/atlassian/performance/tools/awsinfrastructure/api/storage/ApplicationStorage;", "(Lcom/atlassian/performance/tools/awsinfrastructure/api/storage/ApplicationStorage;)V", "DELIMITER", "", "getUnpackedProductName", "connection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "archiveName", "destination", "install", "ssh", "unpack", "", "aws-infrastructure"})
public final class ApplicationStorageWrapper
implements ProductDistribution {
    private final String DELIMITER = "/";
    private final ApplicationStorage applicationStorage;

    @NotNull
    public String install(@NotNull SshConnection ssh, @NotNull String destination) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        String archiveName = this.applicationStorage.download(ssh, destination);
        this.unpack(ssh, archiveName, destination);
        return destination + '/' + this.getUnpackedProductName(ssh, archiveName, destination);
    }

    private final String getUnpackedProductName(SshConnection connection, String archiveName, String destination) {
        String string = "tar -tf " + destination + '/' + archiveName + " --directory " + destination + " | head -n 1";
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(1)");
        return (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)connection.execute(string, duration).getOutput(), (String[])new String[]{this.DELIMITER}, (boolean)false, (int)0, (int)6, null));
    }

    private final void unpack(SshConnection ssh, String archiveName, String destination) {
        String string = "tar -xzf " + destination + '/' + archiveName + " --directory " + destination;
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(1)");
        ssh.execute(string, duration);
    }

    public ApplicationStorageWrapper(@NotNull ApplicationStorage applicationStorage) {
        Intrinsics.checkParameterIsNotNull((Object)applicationStorage, (String)"applicationStorage");
        this.applicationStorage = applicationStorage;
        this.DELIMITER = "/";
    }
}

