/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pdkinstall;

import com.atlassian.pdkinstall.ObrPluginTypeInstaller;
import com.atlassian.plugin.DefaultPluginArtifactFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.context.BundleContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInstaller
implements BundleContextAware {
    private final PluginController pluginController;
    private final PluginAccessor pluginAccessor;
    private final DefaultPluginArtifactFactory pluginArtifactFactory;
    private BundleContext bundleContext;

    public PluginInstaller(PluginController pluginController, PluginAccessor pluginAccessor) {
        this.pluginController = pluginController;
        this.pluginAccessor = pluginAccessor;
        this.pluginArtifactFactory = new DefaultPluginArtifactFactory();
    }

    public synchronized List<String> install(File plugin) throws Exception {
        ArrayList<String> errors = new ArrayList<String>();
        if (plugin.getName().endsWith(".obr")) {
            new ObrPluginTypeInstaller(this.pluginController, this.bundleContext).install(plugin, errors);
        } else {
            String key = this.pluginController.installPlugin(this.pluginArtifactFactory.create(plugin.toURI()));
            if (!this.pluginAccessor.isPluginEnabled(key)) {
                this.pluginController.enablePlugin(key);
            }
        }
        return errors;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

