/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pats.checker;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pats.checker.ActiveUserNotFoundException;
import com.atlassian.pats.checker.UserProvider;
import com.atlassian.sal.api.user.UserKey;
import java.security.Principal;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraUserProvider
implements UserProvider {
    private static final Logger logger = LoggerFactory.getLogger(JiraUserProvider.class);
    private final UserKeyService userKeyService;
    private final UserManager userManager;

    public JiraUserProvider(UserKeyService userKeyService, UserManager userManager) {
        this.userKeyService = userKeyService;
        this.userManager = userManager;
    }

    @Override
    @Nonnull
    public Principal getActiveUserByKey(@Nonnull UserKey userkey) {
        logger.debug("Looking for Jira user with key: [{}]", (Object)userkey);
        return this.getUserByKey(userkey);
    }

    private ApplicationUser getUserByKey(UserKey userkey) {
        return Optional.ofNullable(this.userManager.getUserByKey(userkey.getStringValue())).filter(ApplicationUser::isActive).orElseThrow(() -> new ActiveUserNotFoundException("Unable to locate active user: " + userkey));
    }

    @Override
    @Nonnull
    public Optional<UserKey> getKeyForUsername(@Nonnull String username) {
        return Optional.ofNullable(this.userKeyService.getKeyForUsername(username)).map(UserKey::new);
    }
}

