/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pats.checker;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.pats.checker.ActiveUserNotFoundException;
import com.atlassian.pats.checker.UserProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import java.security.Principal;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceUserProvider
implements UserProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceUserProvider.class);
    private final UserAccessor userAccessor;

    public ConfluenceUserProvider(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    @Nonnull
    public Principal getActiveUserByKey(@Nonnull UserKey userkey) {
        logger.debug("Looking for Confluence user with key: [{}]", (Object)userkey);
        return (Principal)Optional.ofNullable(this.userAccessor.getUserByKey(userkey)).filter(user -> !this.userAccessor.isDeactivated((User)user)).orElseThrow(() -> new ActiveUserNotFoundException("Unable to locate active user: " + userkey));
    }

    @Override
    @Nonnull
    public Optional<UserKey> getKeyForUsername(@Nonnull String username) {
        return Optional.ofNullable(this.userAccessor.getUserByName(username)).map(ConfluenceUser::getKey);
    }
}

