/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paralyzer.core.reporting;

import com.atlassian.paralyzer.api.Extension;
import com.atlassian.paralyzer.api.TestResult;
import com.atlassian.paralyzer.api.engine.AfterEach;
import com.atlassian.paralyzer.api.engine.BeforeEach;
import com.atlassian.paralyzer.api.engine.TestDetails;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public class TestExecutionTimeListener
implements BeforeEach,
AfterEach {
    private final String extensionType = "DetailedInfo";
    private final String propertyName = "executionTime";
    private final Map<String, Instant> startTimes = new ConcurrentHashMap<String, Instant>();

    public Predicate<String> getSupportedEnginePredicate() {
        return b -> true;
    }

    public void afterEach(TestDetails details) {
        Instant now = Instant.now();
        Instant startTime = this.startTimes.get(this.getTestId(details.getTestResult()));
        TestResult result = details.getTestResult();
        if (startTime != null) {
            this.startTimes.remove(this.getTestId(result));
            Double executionTime = (double)(now.toEpochMilli() - startTime.toEpochMilli()) / 1000.0;
            Optional<Extension> infoExtension = this.getExtension(result);
            infoExtension.get().setProperty("executionTime", (Object)executionTime);
        }
    }

    private Optional<Extension> getExtension(TestResult result) {
        Optional<Extension> infoExtension = result.getExtensions().stream().filter(extension -> extension.getExtensionType().equals("DetailedInfo")).findAny();
        if (!infoExtension.isPresent()) {
            infoExtension = Optional.of(new Extension("DetailedInfo"));
            result.addExtension(infoExtension.get());
        }
        return infoExtension;
    }

    public void beforeEach(TestDetails details) {
        this.startTimes.put(this.getTestId(details.getTestResult()), Instant.now());
    }

    private String getTestId(TestResult testResult) {
        return testResult.getTestEngineId() + "_" + testResult.getUniqueId();
    }
}

