/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paralyzer.core.reporting;

import com.atlassian.paralyzer.api.TestResult;
import com.atlassian.paralyzer.api.TestResultCollector;
import com.atlassian.paralyzer.api.TestSuite;
import com.atlassian.paralyzer.core.reporting.SurefireReport;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SurefireReportCollector
implements TestResultCollector {
    private final File reportsDirectory;

    @Inject
    public SurefireReportCollector(@Named(value="reportsDirectory") File reportsDirectory) {
        if (!reportsDirectory.isDirectory() && reportsDirectory.exists()) {
            throw new IllegalArgumentException("reportsDirectory must be directory");
        }
        this.reportsDirectory = reportsDirectory;
    }

    public void collectResults(List<TestResult> results) {
        this.reportsDirectory.mkdirs();
        results.stream().collect(Collectors.groupingBy(TestResult::getTestSuite)).forEach((key, value) -> {
            File reportFile = new File(this.reportsDirectory, this.covertSuiteNameToFilename(this.getPrettyName((TestSuite)key)));
            if (reportFile.exists()) {
                reportFile = new File(this.reportsDirectory, this.covertSuiteNameToFilename(key.getTestEngineId()));
            }
            new SurefireReport(reportFile, (Collection<TestResult>)value, (TestSuite)key).writeReport();
        });
    }

    private String covertSuiteNameToFilename(String key) {
        return "TEST-" + URLEncoder.encode(key) + ".xml";
    }

    private String getPrettyName(TestSuite key) {
        return key.getExtensions().stream().filter(extension -> extension.getExtensionType().equals("PrettyName")).map(extension -> (String)extension.getProperty("name")).filter(Objects::nonNull).findAny().orElse(key.getUniqueId());
    }
}

