/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paralyzer.core.reporting;

import com.atlassian.paralyzer.api.ExtendableType;
import com.atlassian.paralyzer.api.Extension;
import com.atlassian.paralyzer.api.TestResult;
import com.atlassian.paralyzer.api.TestSuite;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurefireReport {
    private static final Logger log = LoggerFactory.getLogger(SurefireReport.class);
    private final File file;
    private final Collection<TestResult> results;
    private final TestSuite suite;
    private OutputFormat format = OutputFormat.createPrettyPrint();
    private int suiteFailures;
    private int suiteErrors;

    public SurefireReport(String filename, Collection<TestResult> results, TestSuite suite) {
        this.file = new File(filename);
        this.results = results;
        this.suite = suite;
    }

    public void writeReport() {
        log.info("Report is being written to file: " + this.file.getAbsolutePath());
        try (FileWriter fileWriter = new FileWriter(this.file);){
            Document document = this.createXmlDocument();
            log.debug(document.asXML());
            XMLWriter writer = new XMLWriter((Writer)fileWriter, this.format);
            writer.write(document);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Document createXmlDocument() {
        Document document = DocumentHelper.createDocument();
        Element testSuiteElement = this.createSuiteElement(document);
        this.suiteFailures = 0;
        this.suiteErrors = 0;
        for (TestResult result : this.results) {
            this.createResultElement(testSuiteElement, result);
        }
        testSuiteElement.addAttribute("failures", Long.toString(this.suiteFailures)).addAttribute("errors", Long.toString(this.suiteErrors));
        return document;
    }

    private Element createSuiteElement(Document document) {
        String suiteName = this.getParamOfExtension((ExtendableType)this.suite, "PrettyName", "name", String.class).orElse(this.suite.getUniqueId());
        Double suiteTime = this.getParamOfExtension((ExtendableType)this.suite, "ExecutionTime", "time", Double.class).orElse(0.0);
        return document.addElement("testsuite").addAttribute("name", suiteName).addAttribute("tests", Integer.toString(this.results.size())).addAttribute("time", Double.toString(suiteTime));
    }

    private <T> Optional<T> getParamOfExtension(ExtendableType extendable, String extensionType, String param, Class<T> aClass) {
        return extendable.getExtensions().stream().filter(extension -> extension.getExtensionType().equals(extensionType)).map(extension -> extension.getProperty(param)).filter(Objects::nonNull).findAny();
    }

    private void createResultElement(Element testSuiteElement, TestResult result) {
        String className = this.getParamOfExtension((ExtendableType)result, "DetailedInfo", "className", String.class).orElse("");
        String methodName = this.getParamOfExtension((ExtendableType)result, "DetailedInfo", "name", String.class).orElse(result.getUniqueId());
        double time = this.getParamOfExtension((ExtendableType)result, "DetailedInfo", "executionTime", Double.class).orElse(0.0);
        Element testCaseElement = testSuiteElement.addElement("testcase").addAttribute("classname", className).addAttribute("name", methodName).addAttribute("time", Double.toString(time));
        switch (result.getResult()) {
            case Ignored: {
                testCaseElement.addElement("skipped");
                break;
            }
            case Failed: {
                ++this.suiteFailures;
                this.addFailureElement(result, testCaseElement, "failure");
                break;
            }
            case Error: {
                ++this.suiteErrors;
                this.addFailureElement(result, testCaseElement, "error");
            }
        }
    }

    private void addFailureElement(TestResult result, Element testcase, String failure) {
        Extension failureDetails = result.getExtensions().stream().filter(extension -> extension.getExtensionType().equals("FailureDetails")).findAny().orElse(new Extension(""));
        String type = (String)failureDetails.getProperty("type");
        String message = (String)failureDetails.getProperty("message");
        String log = Optional.ofNullable(result.getLogs()).orElse("");
        testcase.addElement(failure).addAttribute("type", type).addAttribute("message", message).addCDATA(log);
    }

    public SurefireReport(File file, Collection<TestResult> results, TestSuite suite) {
        this.file = file;
        this.results = results;
        this.suite = suite;
    }

    public void setFormat(OutputFormat format) {
        this.format = format;
    }
}

