/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paralyzer.core;

import com.atlassian.paralyzer.api.engine.LogInterceptor;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleLogInterceptor
implements LogInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ConsoleLogInterceptor.class);
    private ByteArrayOutputStream outputStream;
    private PrintStream printStream;
    private PrintStream outStream;
    private PrintStream errStream;

    public void startIntercepting() {
        log.debug("Started intercepting console output");
        this.outputStream = new ByteArrayOutputStream();
        this.printStream = new PrintStream((OutputStream)new TeeOutputStream((OutputStream)this.outputStream, (OutputStream)System.out));
        this.outStream = System.out;
        this.errStream = System.err;
        System.setOut(this.printStream);
        System.setErr(this.printStream);
    }

    public String stopIntercepting() {
        System.setOut(this.outStream);
        System.setErr(this.errStream);
        log.debug("Stopped intercepting console output");
        return new String(this.outputStream.toByteArray());
    }
}

