package com.atlassian.paralyzer.core;

import com.atlassian.paralyzer.api.TestSuite;
import com.atlassian.paralyzer.api.TestSuiteProcessor;
import com.atlassian.paralyzer.api.TestSuiteProcessorChain;
import lombok.var;

import java.util.LinkedList;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DefaultTestSuiteProcessorChain implements TestSuiteProcessorChain {
    private LinkedList<TestSuiteProcessor> processors = new LinkedList<>();

    @Override
    public Stream<TestSuite> process(Stream<TestSuite> stream, String testEngineId) {
        for (var processor : processors) {
            if (processor.getSupportedEnginePredicate().test(testEngineId)) {
                stream = processor.process(stream);
            }
        }
        return stream;
    }

    @Override
    public void addProcessorAt(TestSuiteProcessor processor, int index) {
        processors.add(index, processor);
    }

    @Override
    public void addProcessorAfter(TestSuiteProcessor processor, Class<? extends TestSuiteProcessor> aClass) {
        var index = IntStream.range(0, processors.size()).filter(i -> processors.get(i).getClass().equals(aClass)).findFirst();
        processors.add(index.orElse(0) + 1, processor);
    }

    @Override
    public void addProcessorBefore(TestSuiteProcessor processor, Class<? extends TestSuiteProcessor> aClass) {
        var index = IntStream.range(0, processors.size()).filter(i -> processors.get(i).getClass().equals(aClass)).findFirst();
        processors.add(index.orElse(0), processor);
    }

    @Override
    public void addProcessorAtBegin(TestSuiteProcessor processor) {
        processors.addFirst(processor);
    }

    @Override
    public void addProcessorAtEnd(TestSuiteProcessor processor) {
        processors.addLast(processor);
    }
}
