package com.atlassian.paralyzer.core;

import com.atlassian.paralyzer.api.ExtendableType;
import com.atlassian.paralyzer.api.Extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultExtendableType implements ExtendableType {
    private List<Extension> extensions = new ArrayList<>();

    @Override
    public List<Extension> getExtensions() {
        return Collections.unmodifiableList(extensions);
    }

    @Override
    public void addExtension(Extension extension) {
        extensions.add(extension);
    }
}
