/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.GDIColor;
import com.benryan.graphics.wmf.MfDcState;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import com.benryan.graphics.wmf.records.RecordCreationException;
import java.awt.Color;

public class MfCmdSetTextColor
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_COLOR = 0;
    private Color color;

    @Override
    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        state.setTextColor(this.color);
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdSetTextColor();
    }

    @Override
    public void setRecord(MfRecord record) {
        int colref = record.getLongParam(0);
        this.setColor(new GDIColor(colref));
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(2);
        record.setLongParam(0, GDIColor.translateColor(this.getColor()));
        return record;
    }

    @Override
    public int getFunction() {
        return 521;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[SET_TEXT_COLOR] textColor=");
        b.append(this.getColor());
        return b.toString();
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }
}

