/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.GDIColor;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import com.benryan.graphics.wmf.records.RecordCreationException;
import java.awt.Color;

public class MfCmdSetPaletteEntries
extends MfCmd {
    private int BASE_RECORD_SIZE = 3;
    private int POS_H_PALETTE = 0;
    private int POS_CSTART = 1;
    private int POS_CENTRIES = 2;
    private int hPalette;
    private Color[] colors;
    private int startPos;

    @Override
    public void replay(WmfFile file) {
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdSetPaletteEntries();
    }

    public Color[] getEntries() {
        return this.colors;
    }

    public void setEntries(Color[] colors) {
        this.colors = colors;
    }

    @Override
    public void setRecord(MfRecord record) {
        int hPalette = record.getParam(this.POS_H_PALETTE);
        int cStart = record.getParam(this.POS_CSTART);
        int cEntries = record.getParam(this.POS_CENTRIES);
        Color[] colors = new Color[cEntries];
        for (int i = 0; i < cEntries; ++i) {
            int colorRef = record.getLongParam(2 * i + this.BASE_RECORD_SIZE);
            GDIColor color = new GDIColor(colorRef);
            colors[i] = color;
        }
        this.setStartPos(cStart);
        this.setEntries(colors);
        this.setHPalette(hPalette);
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        Color[] cEntries = this.getEntries();
        if (cEntries == null) {
            throw new NullPointerException("No CEntries set");
        }
        MfRecord record = new MfRecord(2 * cEntries.length + this.BASE_RECORD_SIZE);
        record.setParam(this.POS_H_PALETTE, this.getHPalette());
        record.setParam(this.POS_CSTART, this.getStartPos());
        record.setParam(this.POS_CENTRIES, cEntries.length);
        for (int i = 0; i < cEntries.length; ++i) {
            record.setLongParam(2 * i + this.BASE_RECORD_SIZE, GDIColor.translateColor(cEntries[i]));
        }
        return record;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public void setStartPos(int startPos) {
        this.startPos = startPos;
    }

    @Override
    public int getFunction() {
        return 55;
    }

    public int getHPalette() {
        return this.hPalette;
    }

    public void setHPalette(int hPalette) {
        this.hPalette = hPalette;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[SET_PALETTE_ENTRIES] entriesCount=");
        if (this.getEntries() == null) {
            b.append(0);
        } else {
            b.append(this.getEntries().length);
        }
        b.append(" hpalette=");
        b.append(this.hPalette);
        return b.toString();
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }
}

