/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfDcState;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import com.benryan.graphics.wmf.records.RecordCreationException;

public class MfCmdSetMapperFlags
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_MAPFLAGS = 0;
    private int mapperflags;

    @Override
    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        state.setMapperFlag(this.mapperflags);
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdSetMapperFlags();
    }

    @Override
    public void setRecord(MfRecord record) {
        int id = record.getLongParam(0);
        this.setMapperFlags(id);
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(2);
        record.setLongParam(0, this.getMapperFlags());
        return record;
    }

    @Override
    public int getFunction() {
        return 561;
    }

    public int getMapperFlags() {
        return this.mapperflags;
    }

    public void setMapperFlags(int id) {
        this.mapperflags = id;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[MAPPERFLAGS] mapperflags=");
        b.append(this.getMapperFlags());
        return b.toString();
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }
}

