/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfDcState;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import com.benryan.graphics.wmf.records.RecordCreationException;

public class MfCmdSetMapMode
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_MAPMODE = 0;
    private int mapmode;

    @Override
    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        state.setMapMode(this.mapmode);
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdSetMapMode();
    }

    @Override
    public void setRecord(MfRecord record) {
        int id = record.getParam(0);
        this.setMapMode(id);
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(1);
        record.setParam(0, this.getMapMode());
        return record;
    }

    @Override
    public int getFunction() {
        return 259;
    }

    public int getMapMode() {
        return this.mapmode;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[MAPMODE] mapmode=");
        b.append(this.getMapMode());
        return b.toString();
    }

    public void setMapMode(int id) {
        this.mapmode = id;
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }
}

