/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfDcState;
import com.benryan.graphics.wmf.MfLogBrush;
import com.benryan.graphics.wmf.MfLogRegion;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class MfCmdPaintRgn
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_REGION = 0;
    private int region;

    @Override
    public void replay(WmfFile file) {
        MfLogRegion regio = file.getRegionObject(this.region);
        MfDcState state = file.getCurrentState();
        state.setLogRegion(regio);
        MfLogBrush brush = state.getLogBrush();
        Graphics2D graph = file.getGraphics2D();
        Rectangle rec = this.scaleRect(regio.getBounds());
        if (brush.isVisible()) {
            state.preparePaint();
            graph.fill(rec);
            state.postPaint();
        }
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdPaintRgn();
    }

    @Override
    public void setRecord(MfRecord record) {
        this.region = record.getParam(0);
    }

    @Override
    public MfRecord getRecord() {
        MfRecord record = new MfRecord(1);
        record.setParam(0, this.getRegion());
        return record;
    }

    public void setRegion(int region) {
        this.region = region;
    }

    public int getRegion() {
        return this.region;
    }

    @Override
    public int getFunction() {
        return 299;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[PAINT_REGION] region=");
        b.append(this.getRegion());
        return b.toString();
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }
}

