/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfDcState;
import com.benryan.graphics.wmf.MfLogBrush;
import com.benryan.graphics.wmf.MfLogRegion;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class MfCmdFrameRegion
extends MfCmd {
    private int width;
    private int height;
    private int scaled_width;
    private int scaled_height;
    private int brushObjectNr;
    private int regionObjectNr;

    @Override
    public void replay(WmfFile file) {
        MfLogBrush brush = file.getBrushObject(this.brushObjectNr);
        MfLogRegion regio = file.getRegionObject(this.regionObjectNr);
        MfDcState state = file.getCurrentState();
        state.setLogRegion(regio);
        state.setLogBrush(brush);
        Graphics2D graph = file.getGraphics2D();
        Rectangle rec = this.scaleRect(regio.getBounds());
        if (brush.isVisible()) {
            Dimension dim = this.getScaledDimension();
            Rectangle2D.Double rect = new Rectangle2D.Double();
            rect.setFrame(rec.x, rec.y, rec.width, dim.height);
            state.preparePaint();
            graph.fill(rect);
            rect.setFrame(rec.x, rec.y - dim.height, rec.width, dim.height);
            graph.fill(rect);
            rect.setFrame(rec.x, rec.y, dim.width, rec.height);
            graph.fill(rect);
            rect.setFrame(rec.width - dim.width, rec.y, dim.width, rec.height);
            graph.fill(rect);
            state.postPaint();
        }
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdFrameRegion();
    }

    @Override
    public int getFunction() {
        return 1065;
    }

    @Override
    public void setRecord(MfRecord record) {
        int height = record.getParam(0);
        int width = record.getParam(1);
        int regio = record.getParam(2);
        int brush = record.getParam(3);
        this.setBrush(brush);
        this.setRegion(regio);
        this.setDimension(width, height);
    }

    @Override
    public MfRecord getRecord() {
        MfRecord record = new MfRecord(4);
        Dimension dim = this.getDimension();
        record.setParam(0, dim.height);
        record.setParam(1, dim.width);
        record.setParam(2, this.getRegion());
        record.setParam(3, this.getBrush());
        return record;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[FRAME_REGION] region=");
        b.append(this.getRegion());
        b.append(" brush=");
        b.append(this.getBrush());
        b.append(" dimension=");
        b.append(this.getDimension());
        return b.toString();
    }

    public void setDimension(int width, int height) {
        this.width = width;
        this.height = height;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setDimension(Dimension dim) {
        this.setDimension(dim.width, dim.height);
    }

    @Override
    protected void scaleXChanged() {
        this.scaled_width = this.getScaledX(this.width);
    }

    @Override
    protected void scaleYChanged() {
        this.scaled_height = this.getScaledY(this.height);
    }

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getScaledDimension() {
        return new Dimension(this.scaled_width, this.scaled_height);
    }

    public int getBrush() {
        return this.brushObjectNr;
    }

    public void setBrush(int brush) {
        this.brushObjectNr = brush;
    }

    public int getRegion() {
        return this.regionObjectNr;
    }

    public void setRegion(int region) {
        this.regionObjectNr = region;
    }
}

