/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfDcState;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;

public class MfCmdChord
extends MfCmd {
    private static final int PARAM_X_END_POS = 0;
    private static final int PARAM_Y_END_POS = 1;
    private static final int PARAM_X_START_POS = 2;
    private static final int PARAM_Y_START_POS = 3;
    private static final int PARAM_BOTTOM_POS = 4;
    private static final int PARAM_RIGHT_POS = 5;
    private static final int PARAM_TOP_POS = 6;
    private static final int PARAM_LEFT_POS = 7;
    private static final int RECORD_SIZE = 8;
    private int x;
    private int y;
    private int width;
    private int height;
    private int xstart;
    private int ystart;
    private int xend;
    private int yend;
    private int scaled_x;
    private int scaled_y;
    private int scaled_width;
    private int scaled_height;
    private int scaled_xstart;
    private int scaled_ystart;
    private int scaled_xend;
    private int scaled_yend;

    @Override
    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
        this.scaled_width = this.getScaledX(this.width);
        this.scaled_xstart = this.getScaledX(this.xstart);
        this.scaled_xend = this.getScaledX(this.xend);
    }

    @Override
    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
        this.scaled_height = this.getScaledY(this.height);
        this.scaled_ystart = this.getScaledY(this.xstart);
        this.scaled_yend = this.getScaledY(this.xend);
    }

    @Override
    public int getFunction() {
        return 2096;
    }

    @Override
    public void replay(WmfFile file) {
        Graphics2D graph = file.getGraphics2D();
        Rectangle rec = this.getBounds();
        Point start = this.getStartingIntersection();
        Point end = this.getEndingIntersection();
        Arc2D.Double arc = new Arc2D.Double();
        arc.setArcType(1);
        arc.setFrame(rec.x, rec.y, rec.width, rec.height);
        arc.setAngles(start.x, start.y, end.x, end.y);
        MfDcState state = file.getCurrentState();
        if (state.getLogBrush().isVisible()) {
            state.preparePaint();
            graph.fill(arc);
            state.postPaint();
        }
        if (state.getLogPen().isVisible()) {
            state.prepareDraw();
            graph.draw(arc);
            state.postDraw();
        }
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdChord();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle getScaledBounds() {
        return new Rectangle(this.scaled_x, this.scaled_y, this.scaled_width, this.scaled_height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setStartingIntersection(int x, int y) {
        this.xstart = x;
        this.ystart = y;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public Point getStartingIntersection() {
        return new Point(this.xstart, this.ystart);
    }

    public Point getScaledStartingIntersection() {
        return new Point(this.scaled_xstart, this.scaled_ystart);
    }

    public void setEndingIntersection(int x, int y) {
        this.xend = x;
        this.yend = y;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public Point getEndingIntersection() {
        return new Point(this.xend, this.yend);
    }

    public Point getScaledEndingIntersection() {
        return new Point(this.scaled_xend, this.scaled_yend);
    }

    @Override
    public void setRecord(MfRecord record) {
        int xend = record.getParam(0);
        int yend = record.getParam(1);
        int xstart = record.getParam(2);
        int ystart = record.getParam(3);
        int bottom = record.getParam(4);
        int right = record.getParam(5);
        int top = record.getParam(6);
        int left = record.getParam(7);
        this.setBounds(left, top, right - left, bottom - top);
        this.setStartingIntersection(xstart, ystart);
        this.setEndingIntersection(xend, yend);
    }

    @Override
    public MfRecord getRecord() {
        MfRecord record = new MfRecord(8);
        Rectangle bounds = this.getBounds();
        Point start = this.getStartingIntersection();
        Point end = this.getEndingIntersection();
        record.setParam(7, (int)bounds.getX());
        record.setParam(6, (int)bounds.getY());
        record.setParam(5, (int)(bounds.getX() + bounds.getWidth()));
        record.setParam(4, (int)(bounds.getY() + bounds.getHeight()));
        record.setParam(3, (int)start.getY());
        record.setParam(2, (int)start.getX());
        record.setParam(1, (int)end.getY());
        record.setParam(0, (int)end.getX());
        return record;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[CHORD] bounds=");
        b.append(this.getBounds());
        b.append(" startIntersection=");
        b.append(this.getStartingIntersection());
        b.append(" endingIntersection=");
        b.append(this.getEndingIntersection());
        return b.toString();
    }
}

