/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.records.MfCmd;
import com.benryan.graphics.wmf.records.MfCmdAnimatePalette;
import com.benryan.graphics.wmf.records.MfCmdArc;
import com.benryan.graphics.wmf.records.MfCmdBitBlt;
import com.benryan.graphics.wmf.records.MfCmdChord;
import com.benryan.graphics.wmf.records.MfCmdCreateBrush;
import com.benryan.graphics.wmf.records.MfCmdCreateDibPatternBrush;
import com.benryan.graphics.wmf.records.MfCmdCreateFont;
import com.benryan.graphics.wmf.records.MfCmdCreatePalette;
import com.benryan.graphics.wmf.records.MfCmdCreatePatternBrush;
import com.benryan.graphics.wmf.records.MfCmdCreatePen;
import com.benryan.graphics.wmf.records.MfCmdCreateRegion;
import com.benryan.graphics.wmf.records.MfCmdDeleteObject;
import com.benryan.graphics.wmf.records.MfCmdDibBitBlt;
import com.benryan.graphics.wmf.records.MfCmdDibStretchBlt;
import com.benryan.graphics.wmf.records.MfCmdEllipse;
import com.benryan.graphics.wmf.records.MfCmdEscape;
import com.benryan.graphics.wmf.records.MfCmdExcludeClipRect;
import com.benryan.graphics.wmf.records.MfCmdExtFloodFill;
import com.benryan.graphics.wmf.records.MfCmdExtTextOut;
import com.benryan.graphics.wmf.records.MfCmdFillRegion;
import com.benryan.graphics.wmf.records.MfCmdFloodFill;
import com.benryan.graphics.wmf.records.MfCmdFrameRegion;
import com.benryan.graphics.wmf.records.MfCmdIntersectClipRect;
import com.benryan.graphics.wmf.records.MfCmdInvertRegion;
import com.benryan.graphics.wmf.records.MfCmdLineTo;
import com.benryan.graphics.wmf.records.MfCmdMoveTo;
import com.benryan.graphics.wmf.records.MfCmdOffsetClipRgn;
import com.benryan.graphics.wmf.records.MfCmdOffsetViewportOrg;
import com.benryan.graphics.wmf.records.MfCmdOffsetWindowOrg;
import com.benryan.graphics.wmf.records.MfCmdPaintRgn;
import com.benryan.graphics.wmf.records.MfCmdPatBlt;
import com.benryan.graphics.wmf.records.MfCmdPie;
import com.benryan.graphics.wmf.records.MfCmdPolyPolygon;
import com.benryan.graphics.wmf.records.MfCmdPolygon;
import com.benryan.graphics.wmf.records.MfCmdPolyline;
import com.benryan.graphics.wmf.records.MfCmdRealisePalette;
import com.benryan.graphics.wmf.records.MfCmdRectangle;
import com.benryan.graphics.wmf.records.MfCmdResizePalette;
import com.benryan.graphics.wmf.records.MfCmdRestoreDc;
import com.benryan.graphics.wmf.records.MfCmdRoundRect;
import com.benryan.graphics.wmf.records.MfCmdSaveDc;
import com.benryan.graphics.wmf.records.MfCmdScaleViewportExt;
import com.benryan.graphics.wmf.records.MfCmdScaleWindowExt;
import com.benryan.graphics.wmf.records.MfCmdSelectClipRegion;
import com.benryan.graphics.wmf.records.MfCmdSelectObject;
import com.benryan.graphics.wmf.records.MfCmdSelectPalette;
import com.benryan.graphics.wmf.records.MfCmdSetBkColor;
import com.benryan.graphics.wmf.records.MfCmdSetBkMode;
import com.benryan.graphics.wmf.records.MfCmdSetDibitsToDevice;
import com.benryan.graphics.wmf.records.MfCmdSetMapMode;
import com.benryan.graphics.wmf.records.MfCmdSetMapperFlags;
import com.benryan.graphics.wmf.records.MfCmdSetPaletteEntries;
import com.benryan.graphics.wmf.records.MfCmdSetPixel;
import com.benryan.graphics.wmf.records.MfCmdSetPolyFillMode;
import com.benryan.graphics.wmf.records.MfCmdSetRop2;
import com.benryan.graphics.wmf.records.MfCmdSetStretchBltMode;
import com.benryan.graphics.wmf.records.MfCmdSetTextAlign;
import com.benryan.graphics.wmf.records.MfCmdSetTextCharExtra;
import com.benryan.graphics.wmf.records.MfCmdSetTextColor;
import com.benryan.graphics.wmf.records.MfCmdSetTextJustification;
import com.benryan.graphics.wmf.records.MfCmdSetViewPortExt;
import com.benryan.graphics.wmf.records.MfCmdSetViewPortOrg;
import com.benryan.graphics.wmf.records.MfCmdSetWindowExt;
import com.benryan.graphics.wmf.records.MfCmdSetWindowOrg;
import com.benryan.graphics.wmf.records.MfCmdStretchBlt;
import com.benryan.graphics.wmf.records.MfCmdStretchDibits;
import com.benryan.graphics.wmf.records.MfCmdTextOut;
import com.benryan.graphics.wmf.records.MfCmdUnknownCommand;
import java.util.Hashtable;

public class CommandFactory {
    private static CommandFactory commandFactory;
    private Hashtable recordTypes;

    public static CommandFactory getInstance() {
        if (commandFactory == null) {
            commandFactory = new CommandFactory();
        }
        return commandFactory;
    }

    public void registerAllKnownTypes() {
        if (this.recordTypes != null) {
            return;
        }
        this.recordTypes = new Hashtable();
        this.registerCommand(new MfCmdAnimatePalette());
        this.registerCommand(new MfCmdArc());
        this.registerCommand(new MfCmdDibBitBlt());
        this.registerCommand(new MfCmdChord());
        this.registerCommand(new MfCmdCreateBrush());
        this.registerCommand(new MfCmdCreateDibPatternBrush());
        this.registerCommand(new MfCmdCreateFont());
        this.registerCommand(new MfCmdCreatePen());
        this.registerCommand(new MfCmdCreatePalette());
        this.registerCommand(new MfCmdCreatePatternBrush());
        this.registerCommand(new MfCmdCreateRegion());
        this.registerCommand(new MfCmdDeleteObject());
        this.registerCommand(new MfCmdEllipse());
        this.registerCommand(new MfCmdEscape());
        this.registerCommand(new MfCmdExcludeClipRect());
        this.registerCommand(new MfCmdExtFloodFill());
        this.registerCommand(new MfCmdExtTextOut());
        this.registerCommand(new MfCmdFillRegion());
        this.registerCommand(new MfCmdFrameRegion());
        this.registerCommand(new MfCmdFloodFill());
        this.registerCommand(new MfCmdInvertRegion());
        this.registerCommand(new MfCmdIntersectClipRect());
        this.registerCommand(new MfCmdLineTo());
        this.registerCommand(new MfCmdMoveTo());
        this.registerCommand(new MfCmdOffsetClipRgn());
        this.registerCommand(new MfCmdOffsetViewportOrg());
        this.registerCommand(new MfCmdOffsetWindowOrg());
        this.registerCommand(new MfCmdBitBlt());
        this.registerCommand(new MfCmdStretchBlt());
        this.registerCommand(new MfCmdPatBlt());
        this.registerCommand(new MfCmdPaintRgn());
        this.registerCommand(new MfCmdPie());
        this.registerCommand(new MfCmdPolyPolygon());
        this.registerCommand(new MfCmdPolygon());
        this.registerCommand(new MfCmdPolyline());
        this.registerCommand(new MfCmdRealisePalette());
        this.registerCommand(new MfCmdRectangle());
        this.registerCommand(new MfCmdRestoreDc());
        this.registerCommand(new MfCmdResizePalette());
        this.registerCommand(new MfCmdRoundRect());
        this.registerCommand(new MfCmdSaveDc());
        this.registerCommand(new MfCmdScaleWindowExt());
        this.registerCommand(new MfCmdScaleViewportExt());
        this.registerCommand(new MfCmdSelectClipRegion());
        this.registerCommand(new MfCmdSelectObject());
        this.registerCommand(new MfCmdSelectPalette());
        this.registerCommand(new MfCmdSetBkMode());
        this.registerCommand(new MfCmdSetBkColor());
        this.registerCommand(new MfCmdSetDibitsToDevice());
        this.registerCommand(new MfCmdSetMapperFlags());
        this.registerCommand(new MfCmdSetMapMode());
        this.registerCommand(new MfCmdSetPaletteEntries());
        this.registerCommand(new MfCmdSetPolyFillMode());
        this.registerCommand(new MfCmdSetPixel());
        this.registerCommand(new MfCmdSetRop2());
        this.registerCommand(new MfCmdSetStretchBltMode());
        this.registerCommand(new MfCmdSetTextCharExtra());
        this.registerCommand(new MfCmdSetTextAlign());
        this.registerCommand(new MfCmdSetTextColor());
        this.registerCommand(new MfCmdSetTextJustification());
        this.registerCommand(new MfCmdSetViewPortExt());
        this.registerCommand(new MfCmdSetViewPortOrg());
        this.registerCommand(new MfCmdSetWindowExt());
        this.registerCommand(new MfCmdSetWindowOrg());
        this.registerCommand(new MfCmdDibStretchBlt());
        this.registerCommand(new MfCmdStretchDibits());
        this.registerCommand(new MfCmdTextOut());
    }

    private void registerCommand(MfCmd command) {
        if (this.recordTypes.get(new Integer(command.getFunction())) != null) {
            throw new IllegalArgumentException("Already registered");
        }
        this.recordTypes.put(new Integer(command.getFunction()), command);
    }

    public MfCmd getCommand(int function) {
        MfCmd cmd;
        if (this.recordTypes == null) {
            this.registerAllKnownTypes();
        }
        if ((cmd = (MfCmd)this.recordTypes.get(new Integer(function))) == null) {
            MfCmdUnknownCommand ucmd = new MfCmdUnknownCommand();
            ucmd.setFunction(function);
            return ucmd;
        }
        return cmd.getInstance();
    }
}

